% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{rater}
\alias{rater}
\title{Fit statistical models to repeated categorical rating data using Stan}
\usage{
rater(
  data,
  model,
  method = "mcmc",
  data_format = "long",
  inits = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A 2D data object: data.frame, matrix, tibble etc. with data in
either long or grouped format.}

\item{model}{Model to fit to data - must be rater_model or a character
string - the name of the model. If the character string is used, the
prior parameters will be set to their default values.}

\item{method}{A length 1 character vector, either \code{"mcmc"} or \code{"optim"}.
This will be fitting method used by Stan. By default \code{"mcmc"}}

\item{data_format}{A length 1 character vector, \code{"long"}, \code{"wide"} and
\code{"grouped"}. The format that the passed data is in. Defaults to \code{"long"}.
See \verb{vignette("data-formats)} for details.}

\item{inits}{The initialization points of the fitting algorithm}

\item{verbose}{Should \code{rater()} produce information about the progress
of the chains while using the MCMC algorithm. Defaults to \code{TRUE}}

\item{...}{Extra parameters which are passed to the Stan fitting interface.}
}
\value{
An object of class rater_fit containing the fitted parameters.
}
\description{
This functions allows the user to fit statistical models of noisy
categorical rating, based on the Dawid-Skene model, using Bayesian
inference. A variety of data formats and models are supported. Inference
is done using Stan, allowing models to be fit efficiently, using both
optimisation and Markov Chain Monte Carlo (MCMC).
}
\details{
The default MCMC algorithm used by Stan is No U Turn Sampling
(NUTS) and the default optimisation method is LGFGS. For MCMC 4 chains
are run be default with 2000 iterations in total each.
}
\examples{
\donttest{

# Fit a model using MCMC (the default).
mcmc_fit <- rater(anesthesia, "dawid_skene")

# Fit a model using optimisation.
optim_fit <- rater(anesthesia, dawid_skene(), method = "optim")

# Fit a model using passing data grouped data.
grouped_fit <- rater(caries, dawid_skene(), data_format = "grouped")

}

}
\seealso{
\code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}, \code{\link[rstan:stanmodel-method-optimizing]{rstan::optimizing()}}
}
