% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRE.R
\name{CRE}
\alias{CRE}
\title{Cumulative Residual Entropy (CRE) Function}
\usage{
CRE(
  x,
  window = 3,
  method = "classic",
  rasterOut = TRUE,
  rescale = FALSE,
  na.tolerance = 1,
  simplify = 2,
  np = 1,
  cluster.type = "SOCK",
  progBar = TRUE,
  debugging = FALSE
)
}
\arguments{
\item{x}{A matrix, SpatRaster, or a list of SpatRaster objects.}

\item{window}{The size of the moving window, must be an odd integer.}

\item{method}{The method for CRE computation, either "classic" or "multidimensional".}

\item{rasterOut}{Logical, if TRUE, returns a SpatRaster, else returns a matrix.}

\item{rescale}{Logical, if TRUE, rescales the data before processing.}

\item{na.tolerance}{A numeric value between 0 and 1, indicating the tolerance level for NA values.}

\item{simplify}{Integer, the number of decimal places for data rounding in case of float numbers.}

\item{np}{The number of parallel processes to use.}

\item{cluster.type}{The type of parallel cluster to use, options are "SOCK", "FORK", or "MPI".}

\item{progBar}{logical. If TRUE a progress bar is shown.}

\item{debugging}{Logical, if TRUE, provides additional debugging information during execution.}
}
\value{
Depending on the 'rasterOut' parameter, this function returns either a SpatRaster or a matrix.
}
\description{
Computes the Cumulative Residual Entropy (CRE) for spatial raster data. This function 
can be used with either a single raster layer or a list of raster layers. It supports 
both classic and multidimensional methods for CRE computation.
}
\examples{
\dontrun{
# For a matrix input:
result <- CRE(matrix_data, window=3, method="classic")

# For a SpatRaster input:
result <- CRE(raster_data, window=3, method="classic", rasterOut=TRUE)
}

}
