% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{OutlierMaskers}
\alias{OutlierMaskers}
\alias{maskOutliers}
\alias{maskOutliersMasked}
\title{Exclude SD-based outliers in each matrix column}
\usage{
maskOutliers(x, sdlim = 3)

maskOutliersMasked(x, mask, sdlim = 3)
}
\arguments{
\item{x}{Matrix in which to mark SD-based outliers by column.}

\item{sdlim}{Standard deviation limit to apply; 
values beyond are classified as outliers and masked.}

\item{mask}{A logical matrix determining which data points to include and which not to.}
}
\value{
A logical matrix with outliers (and previously masked values) marked as \code{FALSE}.
}
\description{
Generate or update a mask matrix based on outlyingness of values in each column.
}
\examples{
# Generate data with outliers
testmat<-matrix(rnorm(100),ncol=2)
testmat[1,]<-100
testmat[2,]<-50

# Detect outliers
maskOutliers(testmat)

# Generate a mask
testmask<-matrix(TRUE,ncol=2,nrow=50)
testmask[1,1]<-FALSE

# Detect outliers with pre-existing mask
maskOutliersMasked(x=testmat, 
                   mask=testmask, sdlim = 3)

}
