% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flipSign.R
\name{flipSign}
\alias{flipSign}
\title{Flip sign of coordinates}
\usage{
flipSign(
  coordVec,
  country,
  returnMultiple = FALSE,
  filterByLand = TRUE,
  crs = 4326
)
}
\arguments{
\item{coordVec}{numeric vector of length 2: longitude, latitude}

\item{country}{the country that is associated with the record}

\item{returnMultiple}{if multiple sign flips lead to the correct country,
return all options.  If \code{FALSE}, returns the coords with the fewest
needed sign flips.}

\item{filterByLand}{if \code{TRUE}, alternative coords will be tested for
whether or not they fall on land.}

\item{crs}{the crs of the coordinate.}
}
\value{
list with 2 elements \item{matched}{ logical: Was the country
matched } \item{newcoords}{ matrix of coordinates that were successful.  }
}
\description{
Checks for coordinate sign mistakes by checking all possibilities against
country occupancy.
}
\details{
This function generates all possible coordinates with different signs, and
runs \code{\link{closestCountry}} on each, returning the coordinates that
lead to a country match. It ignores coordinate options that do not pass
\code{\link{filterByLand}}.

If a point falls close to the boundary between two countries, it is still
considered a match.
}
\examples{

#correct coordinates
flipSign(c(4.28, 39.98), country = 'Spain')

#mistake in coordinate sign
flipSign(c(115.436, 32.657), country = 'United States')

#incorrect sign on both long and lat, but not possible to distinguish for longitude
#except when we consider which alternative coords fall on land.
flipSign(c(-4.28, -39.98), country = 'Spain', filterByLand = FALSE, returnMultiple = TRUE)
flipSign(c(-4.28, -39.98), country = 'Spain', returnMultiple = TRUE)

#coordinates are incorrect
flipSign(c(4.28, 59.98), country = 'Spain')

}
\author{
Pascal Title
}
