% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_rs_probabilities.R
\name{cluster_rs_probabilities}
\alias{cluster_rs_probabilities}
\title{Probabilties of assignment: Cluster Random Assignment}
\usage{
cluster_rs_probabilities(clust_var, n = NULL, prob = NULL, simple = FALSE,
  check_inputs = TRUE)
}
\arguments{
\item{clust_var}{A vector of length N that indicates which cluster each unit belongs to.}

\item{n}{Use for a design in which n clusters are sampled. (optional)}

\item{prob}{Use for a design in which either floor(N_clusters*prob) or ceiling(N_clusters*prob) clusters are sampled. The probability of being sampled is exactly prob because with probability 1-prob, floor(N_clusters*prob) clusters will be sampled and with probability prob, ceiling(N_clusters*prob) clusters will be sampled. prob must be a real number between 0 and 1 inclusive. (optional)}

\item{simple}{logical, defaults to FALSE. If TRUE, simple random sampling of clusters. When simple = TRUE, please do not specify n.}

\item{check_inputs}{logical. Defaults to TRUE.}
}
\value{
A vector length N indicating the probability of being sampled.
}
\description{
Probabilties of assignment: Cluster Random Assignment
}
\examples{

# Two Group Designs
clust_var <- rep(letters, times = 1:26)
probs <- cluster_rs_probabilities(clust_var = clust_var)
table(probs, clust_var)

prob_mat <- cluster_rs_probabilities(clust_var = clust_var, n = 10)
table(probs, clust_var)

prob_mat <- cluster_rs_probabilities(clust_var = clust_var, prob = .3)
table(probs, clust_var)


}
