% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ra_probabilities.R
\name{complete_ra_probabilities}
\alias{complete_ra_probabilities}
\title{Probabilties of assignment: Complete Random Assignment}
\usage{
complete_ra_probabilities(N, m = NULL, prob = NULL, num_arms = NULL,
  m_each = NULL, prob_each = NULL, condition_names = NULL)
}
\arguments{
\item{N}{The total number of units in the experimental sample (required).}

\item{m}{If specified, a two-group design is assumed. m is the total number of units to be assigned to treatment. Should only be specified for a two group design in which exactly m of N units are assigned to treatment. If not specified, half of the sample (N/2) will be assigned to treatment (if N is odd, m will be set to either floor(N/2) or ceiling(N/2) with equal probability. m is NULL by default.}

\item{prob}{The probability of assignment to treatment. If specified, a two-group design is assumed.}

\item{num_arms}{The total number of treatment arms. If unspecified, num_arms will be determined from the length of m_each, prob_each, or condition_names.}

\item{m_each}{A numeric vector giving the size of each treatment group. Must sum to N. If unspecified, equally sized (rounded) groups will be assumed.}

\item{prob_each}{A numeric giving the probability of assignment to each treatment arm. Must sum to 1. Please note that due to rounding, these probabilities are approximate. For finer control, please use m_each.}

\item{condition_names}{A character vector giving the names of the treatment groups. If unspecified, the treatment groups will be named T1, T2, T3, etc. An execption is a two-group design in which N only or N and m are specified, in which the condition names are 0 and 1.}
}
\value{
A matrix of probabilities of assignment
}
\description{
Probabilties of assignment: Complete Random Assignment
}
\examples{
# 2-arm designs
complete_ra_probabilities(N=100)
complete_ra_probabilities(N=100, m=50)
complete_ra_probabilities(N=100, prob = .3)

complete_ra_probabilities(N=100, m_each = c(30, 70), 
                          condition_names = c("control", "treatment"))

# Multi-arm Designs
complete_ra_probabilities(N=100, num_arms=3)
complete_ra_probabilities(N=100, m_each=c(30, 30, 40))

complete_ra_probabilities(N=100, m_each=c(30, 30, 40), 
                          condition_names=c("control", "placebo", "treatment"))

complete_ra_probabilities(N=100, condition_names=c("control", "placebo", "treatment"))
complete_ra_probabilities(N=100, prob_each = c(.2, .7, .1))

}

