% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radrs.R
\name{radrs}
\alias{radrs}
\title{Tumor Response Analysis Dataset (ADRS)}
\usage{
radrs(
  adsl,
  avalc = NULL,
  lookup = NULL,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(AVISIT = c(NA, 0.1), AVAL = c(1234, 0.1), AVALC = c(1234, 0.1)),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{avalc}{(\verb{character vector})\cr Analysis value categories.}

\item{lookup}{(\code{data.frame})\cr Additional parameters.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADRS data \code{cadrs} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radrs} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating a random Tumor Response Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per subject per parameter per analysis visit per analysis date.
SDTM variables are populated on new records coming from other single records.
Otherwise, SDTM variables are left blank.

Keys: \code{STUDYID}, \code{USUBJID}, \code{PARAMCD}, \code{AVISITN}, \code{ADT}, \code{RSSEQ}
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)

adrs <- radrs(adsl, seed = 2)
adrs
}
