/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.variables.stateSpaceTypes;

import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FiniteStateSpace
extends StateSpaceType
implements Iterable<String> {
    private int numberOfStates;
    private final List<String> statesNames;
    private final Map<String, Integer> mapStatesNames;

    public FiniteStateSpace(int numberOfStates1) {
        super(StateSpaceTypeEnum.FINITE_SET);
        this.numberOfStates = numberOfStates1;
        this.statesNames = new ArrayList<String>();
        this.mapStatesNames = new ConcurrentHashMap<String, Integer>();
        for (int i = 0; i < numberOfStates1; ++i) {
            this.statesNames.add(i + ".0");
            this.mapStatesNames.put(i + ".0", i);
        }
    }

    public FiniteStateSpace(List<String> statesNames1) {
        super(StateSpaceTypeEnum.FINITE_SET);
        this.numberOfStates = statesNames1.size();
        this.statesNames = new ArrayList<String>();
        this.mapStatesNames = new ConcurrentHashMap<String, Integer>();
        for (int i = 0; i < statesNames1.size(); ++i) {
            this.statesNames.add(statesNames1.get(i));
            this.mapStatesNames.put(statesNames1.get(i), i);
        }
    }

    public int getNumberOfStates() {
        return this.numberOfStates;
    }

    public String getStatesName(int state) {
        return this.statesNames.get(state);
    }

    public int getIndexOfState(String stateName) {
        return this.mapStatesNames.get(stateName);
    }

    @Override
    public Iterator<String> iterator() {
        return this.statesNames.iterator();
    }

    public List<String> getStatesNames() {
        return this.statesNames;
    }

    @Override
    public String stringValue(double value) {
        return this.statesNames.get((int)value);
    }
}

