/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FixedBatchParallelSpliteratorWrapper<T>
implements Spliterator<T> {
    private final Spliterator<T> spliterator;
    private final int batchSize;
    private final int characteristics;
    private long est;

    public FixedBatchParallelSpliteratorWrapper(Spliterator<T> toWrap, long est, int batchSize) {
        int c = toWrap.characteristics();
        this.characteristics = (c & 0x40) != 0 ? c | 0x4000 : c;
        this.spliterator = toWrap;
        this.est = est;
        this.batchSize = batchSize;
    }

    public FixedBatchParallelSpliteratorWrapper(Spliterator<T> toWrap, int batchSize) {
        this(toWrap, toWrap.estimateSize(), batchSize);
    }

    public static <T> Stream<T> toFixedBatchStream(Stream<T> in, int batchSize) {
        return StreamSupport.stream(new FixedBatchParallelSpliteratorWrapper(in.spliterator(), batchSize), true);
    }

    @Override
    public Spliterator<T> trySplit() {
        HoldingConsumer holder = new HoldingConsumer();
        if (!this.spliterator.tryAdvance(holder)) {
            return null;
        }
        Object[] a = new Object[this.batchSize];
        int j = 0;
        do {
            a[j] = holder.value;
        } while (++j < this.batchSize && this.tryAdvance(holder));
        if (this.est != Long.MAX_VALUE) {
            this.est -= (long)j;
        }
        return Spliterators.spliterator(a, 0, j, this.characteristics());
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        return this.spliterator.tryAdvance(action);
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.spliterator.forEachRemaining(action);
    }

    @Override
    public Comparator<? super T> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    static final class HoldingConsumer<T>
    implements Consumer<T> {
        Object value;

        HoldingConsumer() {
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }
    }
}

