% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{chol_update}
\alias{chol_update}
\title{Rank-one Update of Cholesky Decomposition}
\usage{
chol_update(L, u)
}
\arguments{
\item{L}{A lower triangular matrix. Strictly upper diagonal part is not referenced.}

\item{u}{A vector with with length matching with the dimensions of L.}
}
\value{
Updated L.
}
\description{
Given the lower triangular matrix L obtained from the Cholesky decomposition of A,
function \code{chol_update} updates L such that it corresponds to the decomposition of A + u*u'.
}
\examples{

L <- matrix(c(4,3,0,5), 2, 2)
u <- c(1, 2)
chol_update(L, u)
t(chol(L \%*\% t(L) + u \%*\% t(u)))

}

