% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{implied_jump_process_volatility}
\alias{implied_jump_process_volatility}
\title{Implied volatility of any instrument}
\usage{
implied_jump_process_volatility(instrument_price, instrument, ...,
  starting_volatility_estimate = 0.85, relative_tolerance = 0.005,
  max.iter = 100, max_vola = 4)
}
\arguments{
\item{instrument_price}{Target price for root finder}

\item{instrument}{Instrument to search for the target price on, passed as
the sole instrument to \code{\link{find_present_value}}}

\item{...}{Additional arguments to be passed on to \code{\link{find_present_value}}}

\item{starting_volatility_estimate}{Bisection method original guess}

\item{relative_tolerance}{Relative tolerance in instrument price defining the root-finder halting condition}

\item{max.iter}{Maximum number of root-finder iterations allowed}

\item{max_vola}{Maximum volatility to try}
}
\value{
A list of present values, with the same names as \code{instruments}
}
\description{
Use the grid solver to generate instrument prices via \code{find_present_value} and run them
  through a bisective root search method until a constant volatility matching the provided
  instrument price has been found.
}
\details{
Unlike \code{american_implied_volatility}, this routine allows for any legal
 term structures and equity-linked default intensities.  For that reason, it eschews
 the control variate tricks that make \code{american_implied_volatility} so much faster.

Note that equity-linked default intensities can result in instrument prices that
  are not monotonic in volatility.  This bisective root finder will find a solution
  but not necessarily any particular one.
}
\examples{
implied_jump_process_volatility(
    25, AmericanOption(maturity=1.1, strike=100, callput=-1),
    S0=100, num_time_steps=50, relative_tolerance=1.e-3)

}
\seealso{
\code{\link{find_present_value}} for the underlying
  pricing algorithm, \code{\link{implied_volatility_with_term_struct}} for European options
  without equity dependence of default intensity, \code{\link{american_implied_volatility}} for the same on American options

Other Implied Volatilities: \code{\link{american_implied_volatility}},
  \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{fit_variance_cumulation}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}},
  \code{\link{implied_volatility}}

Other Equity Dependent Default Intensity: \code{\link{find_present_value}},
  \code{\link{fit_to_option_market_df}},
  \code{\link{fit_variance_cumulation}},
  \code{\link{form_present_value_grid}}
}
\concept{Equity Dependent Default Intensity}
\concept{Implied Volatilities}
\concept{implied volatility}
\keyword{calibration}
