% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-markdown.R
\name{markdown_segment}
\alias{markdown_segment}
\alias{markdown_frame}
\title{Segment markdown text}
\usage{
markdown_segment(
  text,
  tags = c("h1", "h2", "h3", "h4"),
  trim = FALSE,
  omit_empty = FALSE
)

markdown_frame(text, frame_by = c("h1", "h2", "h3"), segment_by = NULL)
}
\arguments{
\item{text}{Markdown string}

\item{tags, segment_by}{A character vector of html tag names, e.g.,
\code{c("h1", "h2", "h3", "pre")}}

\item{trim}{logical, trim whitespace on segments}

\item{omit_empty}{logical, whether to remove empty segments}

\item{frame_by}{Character vector of tags that will become columns in the returned dataframe.}
}
\value{
A named character vector. Names will correspond to \code{tags}, or \code{""}
for content in between tags.
}
\description{
Segment markdown text
}
\examples{
md <- r"---(

# Sample Markdown File

## Introduction

This is a sample **Markdown** file for testing.

### Features

- Simple **bold** text
- _Italicized_ text
- `Inline code`
- A [link](https://example.com)
- ‘Curly quotes are 3 bytes chars.’ Non-ascii text is fine.

This is a paragraph with <p> tag.

This next segment with code has a <pre> tag

```r
hello_world <- function() {
  cat("Hello, World!\n")
}
```

A table <table>:

  | Name  | Age | City      |
  |-------|----:|-----------|
  | Alice |  25 | New York  |
  | Bob   |  30 | London    |


## Conclusion

Common tags:

- h1, h2, h3, h4, h5, h6: section headings
- p: paragraph (prose)
- pre: pre-formatted text, meant to be displayed with monospace font.
  Typically code or code output
- blockquote: A blockquote
- table: A table
- ul: Unordered list
- ol: Ordered list
- li: Individual list item in a <ul> or <ol>


)---"
markdown_segment(md) |> tibble::enframe()
markdown_segment(md |> trimws()) |> tibble::enframe()
markdown_segment(md, c("li"), trim = TRUE, omit_empty = TRUE) |> tibble::enframe()
markdown_segment(md, c("table"), trim = TRUE, omit_empty = TRUE) |> tibble::enframe()
markdown_segment(md, c("ul"), trim = TRUE, omit_empty = TRUE) |> tibble::enframe()
}
