% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dk_reverse.R
\name{dk_reverse}
\alias{dk_reverse}
\title{Calculate amount of radioactivity given interval.}
\usage{
dk_reverse(A1, half_life, t)
}
\arguments{
\item{A1}{The target activity or related parameter, such as dose rate.}

\item{half_life}{Half-life. Units are arbitrary, but must match time past.}

\item{t}{Time past since activity of interest. Units are arbitrary, but must
match half-life.}
}
\value{
The original activity or related parameter.
}
\description{
Calculate the activity at an earlier time, given the time past,
  the half-life, and the activity at time, t. The result will provide
  activity in the same units as provided for present activity. Time past and
  half-life must be in consistent units.
}
\examples{
# A Sr-90 Radioisotope thermoelectric generator is discovered and measured. 
# The activity is estimated to be around 400 TBq. Original RTG's of this 
# type contained 1480 TBq when built 50 years earlier. We're wondering if 
# much has leaked. So, we compute the original from what we have. 
dk_reverse(400, 28.79, 50)
}
\seealso{
Other decay corrections: \code{\link{dk_activity}},
  \code{\link{dk_cf}},
  \code{\link{dk_pct_to_num_half_life}},
  \code{\link{dk_time}}
}
\concept{decay corrections}
