% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans_clus.R
\name{kmeans_clus}
\alias{kmeans_clus}
\title{K-means cluster analysis}
\usage{
kmeans_clus(dataset, vars, hc_init = TRUE, distance = "sq.euclidian",
  method = "ward.D", seed = 1234, nr_clus = 2, data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{vars}{Vector of variables to include in the analysis}

\item{hc_init}{Use centers from hier_clus as the starting point}

\item{distance}{Distance for hier_clus}

\item{method}{Method for hier_clus}

\item{seed}{Random see to use for kmeans if hc_init is FALSE}

\item{nr_clus}{Number of clusters to extract}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables used in kmeans_clus as an object of class kmeans_clus
}
\description{
K-means cluster analysis
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/kmeans_clus.html} for an example in Radiant
}
\examples{
result <- kmeans_clus("shopping", c("v1:v6"))

}
\seealso{
\code{\link{summary.kmeans_clus}} to summarize results

\code{\link{plot.kmeans_clus}} to plot results

\code{\link{store.kmeans_clus}} to add cluster membership to the selected dataset
}

