% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rFractionalWishart.R
\name{FractionalWishart}
\alias{FractionalWishart}
\title{Fractional Wishart Helper Function}
\usage{
FractionalWishart(df, Sigma, covariance = FALSE)
}
\arguments{
\item{df}{numeric parameter, \dQuote{degrees of freedom}.}

\item{Sigma}{positive definite (\eqn{p\times p}{p * p}) \dQuote{scale}
    matrix, the matrix parameter of the distribution.}

\item{covariance}{logical on whether a covariance matrix should be generated}
}
\value{
A numeric array of dimension \code{p * p * n}, where each array is a positive semidefinite matrix, a realization of the Wishart distribution W_p(Sigma, df)
}
\description{
Fractional Wishart Helper Function
}
\details{
If X_1, ..., X_m is a sample of m independent multivariate Gaussians with mean vector 0, and covariance matrix Sigma, 
the distribution of M = X'X is W_p(Sigma, m).
}
\examples{
FractionalWishart(22.5, diag(1, 20))
}
\keyword{internal}
