/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.test.BaseTest;

public class TestTrees
extends BaseTest {
    TreeAdaptor adaptor = new CommonTreeAdaptor();
    protected boolean debug = false;

    public void testSingleNode() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        TestTrees.assertNull((Object)commonTree.parent);
        TestTrees.assertEquals((int)-1, (int)commonTree.childIndex);
    }

    public void testTwoChildrenOfNilRoot() throws Exception {
        CommonTree commonTree = (CommonTree)this.adaptor.nil();
        V v = new V(101, 2);
        V v2 = new V(new CommonToken(102, "102"));
        this.adaptor.addChild(commonTree, v);
        this.adaptor.addChild(commonTree, v2);
        TestTrees.assertNull((Object)commonTree.parent);
        TestTrees.assertEquals((int)-1, (int)commonTree.childIndex);
        TestTrees.assertEquals((int)0, (int)v.childIndex);
        TestTrees.assertEquals((int)1, (int)v2.childIndex);
    }

    public void test4Nodes() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        commonTree.addChild(new CommonTree(new CommonToken(102)));
        commonTree.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        TestTrees.assertNull((Object)commonTree.parent);
        TestTrees.assertEquals((int)-1, (int)commonTree.childIndex);
    }

    public void testList() throws Exception {
        CommonTree commonTree = new CommonTree((Token)null);
        CommonTree commonTree2 = new CommonTree(new CommonToken(101));
        commonTree.addChild(commonTree2);
        CommonTree commonTree3 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree3);
        CommonTree commonTree4 = new CommonTree(new CommonToken(103));
        commonTree.addChild(commonTree4);
        TestTrees.assertNull((Object)commonTree.parent);
        TestTrees.assertEquals((int)-1, (int)commonTree.childIndex);
        TestTrees.assertEquals((Object)commonTree, (Object)commonTree2.parent);
        TestTrees.assertEquals((int)0, (int)commonTree2.childIndex);
        TestTrees.assertEquals((Object)commonTree, (Object)commonTree3.parent);
        TestTrees.assertEquals((int)1, (int)commonTree3.childIndex);
        TestTrees.assertEquals((Object)commonTree, (Object)commonTree4.parent);
        TestTrees.assertEquals((int)2, (int)commonTree4.childIndex);
    }

    public void testList2() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(5));
        CommonTree commonTree2 = new CommonTree((Token)null);
        CommonTree commonTree3 = new CommonTree(new CommonToken(101));
        commonTree2.addChild(commonTree3);
        CommonTree commonTree4 = new CommonTree(new CommonToken(102));
        commonTree2.addChild(commonTree4);
        CommonTree commonTree5 = new CommonTree(new CommonToken(103));
        commonTree2.addChild(commonTree5);
        commonTree.addChild(commonTree2);
        TestTrees.assertNull((Object)commonTree.parent);
        TestTrees.assertEquals((int)-1, (int)commonTree.childIndex);
        TestTrees.assertEquals((Object)commonTree, (Object)commonTree3.parent);
        TestTrees.assertEquals((int)0, (int)commonTree3.childIndex);
        TestTrees.assertEquals((Object)commonTree, (Object)commonTree3.parent);
        TestTrees.assertEquals((int)1, (int)commonTree4.childIndex);
        TestTrees.assertEquals((Object)commonTree, (Object)commonTree3.parent);
        TestTrees.assertEquals((int)2, (int)commonTree5.childIndex);
    }

    public void testAddListToExistChildren() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(5));
        commonTree.addChild(new CommonTree(new CommonToken(6)));
        CommonTree commonTree2 = new CommonTree((Token)null);
        CommonTree commonTree3 = new CommonTree(new CommonToken(101));
        commonTree2.addChild(commonTree3);
        CommonTree commonTree4 = new CommonTree(new CommonToken(102));
        commonTree2.addChild(commonTree4);
        CommonTree commonTree5 = new CommonTree(new CommonToken(103));
        commonTree2.addChild(commonTree5);
        commonTree.addChild(commonTree2);
        TestTrees.assertNull((Object)commonTree.parent);
        TestTrees.assertEquals((int)-1, (int)commonTree.childIndex);
        TestTrees.assertEquals((Object)commonTree, (Object)commonTree3.parent);
        TestTrees.assertEquals((int)1, (int)commonTree3.childIndex);
        TestTrees.assertEquals((Object)commonTree, (Object)commonTree3.parent);
        TestTrees.assertEquals((int)2, (int)commonTree4.childIndex);
        TestTrees.assertEquals((Object)commonTree, (Object)commonTree3.parent);
        TestTrees.assertEquals((int)3, (int)commonTree5.childIndex);
    }

    public void testDupTree() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTree commonTree4 = (CommonTree)new CommonTreeAdaptor().dupTree(commonTree);
        TestTrees.assertNull((Object)commonTree4.parent);
        TestTrees.assertEquals((int)-1, (int)commonTree4.childIndex);
        commonTree4.sanityCheckParentAndChildIndexes();
    }

    public void testBecomeRoot() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(5));
        CommonTree commonTree2 = new CommonTree((Token)null);
        commonTree2.addChild(new CommonTree(new CommonToken(101)));
        commonTree2.addChild(new CommonTree(new CommonToken(102)));
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTreeAdaptor commonTreeAdaptor = new CommonTreeAdaptor();
        commonTreeAdaptor.becomeRoot(commonTree, (Object)commonTree2);
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testBecomeRoot2() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(5));
        CommonTree commonTree2 = new CommonTree(new CommonToken(101));
        commonTree2.addChild(new CommonTree(new CommonToken(102)));
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTreeAdaptor commonTreeAdaptor = new CommonTreeAdaptor();
        commonTreeAdaptor.becomeRoot(commonTree, (Object)commonTree2);
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testBecomeRoot3() throws Exception {
        CommonTree commonTree = new CommonTree((Token)null);
        commonTree.addChild(new CommonTree(new CommonToken(5)));
        CommonTree commonTree2 = new CommonTree((Token)null);
        commonTree2.addChild(new CommonTree(new CommonToken(101)));
        commonTree2.addChild(new CommonTree(new CommonToken(102)));
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTreeAdaptor commonTreeAdaptor = new CommonTreeAdaptor();
        commonTreeAdaptor.becomeRoot(commonTree, (Object)commonTree2);
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testBecomeRoot5() throws Exception {
        CommonTree commonTree = new CommonTree((Token)null);
        commonTree.addChild(new CommonTree(new CommonToken(5)));
        CommonTree commonTree2 = new CommonTree(new CommonToken(101));
        commonTree2.addChild(new CommonTree(new CommonToken(102)));
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTreeAdaptor commonTreeAdaptor = new CommonTreeAdaptor();
        commonTreeAdaptor.becomeRoot(commonTree, (Object)commonTree2);
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testBecomeRoot6() throws Exception {
        CommonTree commonTree = (CommonTree)this.adaptor.nil();
        CommonTree commonTree2 = (CommonTree)this.adaptor.nil();
        commonTree2 = (CommonTree)this.adaptor.becomeRoot(new CommonTree(new CommonToken(5)), (Object)commonTree2);
        this.adaptor.addChild(commonTree2, new CommonTree(new CommonToken(6)));
        this.adaptor.addChild(commonTree, commonTree2);
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceWithNoChildren() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(5));
        boolean bl = false;
        try {
            commonTree.replaceChildren(0, 0, commonTree2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        TestTrees.assertTrue((boolean)bl);
    }

    public void testReplaceWithOneChildren() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        CommonTree commonTree2 = new CommonTree(new CommonToken(99, "b"));
        commonTree.addChild(commonTree2);
        CommonTree commonTree3 = new CommonTree(new CommonToken(99, "c"));
        commonTree.replaceChildren(0, 0, commonTree3);
        String string = "(a c)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceInMiddle() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = new CommonTree(new CommonToken(99, "x"));
        commonTree.replaceChildren(1, 1, commonTree2);
        String string = "(a b x d)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceAtLeft() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = new CommonTree(new CommonToken(99, "x"));
        commonTree.replaceChildren(0, 0, commonTree2);
        String string = "(a x c d)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceAtRight() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = new CommonTree(new CommonToken(99, "x"));
        commonTree.replaceChildren(2, 2, commonTree2);
        String string = "(a b c x)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceOneWithTwoAtLeft() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = (CommonTree)this.adaptor.nil();
        commonTree2.addChild(new CommonTree(new CommonToken(99, "x")));
        commonTree2.addChild(new CommonTree(new CommonToken(99, "y")));
        commonTree.replaceChildren(0, 0, commonTree2);
        String string = "(a x y c d)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceOneWithTwoAtRight() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = (CommonTree)this.adaptor.nil();
        commonTree2.addChild(new CommonTree(new CommonToken(99, "x")));
        commonTree2.addChild(new CommonTree(new CommonToken(99, "y")));
        commonTree.replaceChildren(2, 2, commonTree2);
        String string = "(a b c x y)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceOneWithTwoInMiddle() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = (CommonTree)this.adaptor.nil();
        commonTree2.addChild(new CommonTree(new CommonToken(99, "x")));
        commonTree2.addChild(new CommonTree(new CommonToken(99, "y")));
        commonTree.replaceChildren(1, 1, commonTree2);
        String string = "(a b x y d)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceTwoWithOneAtLeft() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = new CommonTree(new CommonToken(99, "x"));
        commonTree.replaceChildren(0, 1, commonTree2);
        String string = "(a x d)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceTwoWithOneAtRight() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = new CommonTree(new CommonToken(99, "x"));
        commonTree.replaceChildren(1, 2, commonTree2);
        String string = "(a b x)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceAllWithOne() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = new CommonTree(new CommonToken(99, "x"));
        commonTree.replaceChildren(0, 2, commonTree2);
        String string = "(a x)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    public void testReplaceAllWithTwo() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(99, "a"));
        commonTree.addChild(new CommonTree(new CommonToken(99, "b")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "c")));
        commonTree.addChild(new CommonTree(new CommonToken(99, "d")));
        CommonTree commonTree2 = (CommonTree)this.adaptor.nil();
        commonTree2.addChild(new CommonTree(new CommonToken(99, "x")));
        commonTree2.addChild(new CommonTree(new CommonToken(99, "y")));
        commonTree.replaceChildren(0, 2, commonTree2);
        String string = "(a x y)";
        TestTrees.assertEquals((String)string, (String)commonTree.toStringTree());
        commonTree.sanityCheckParentAndChildIndexes();
    }

    static class V
    extends CommonTree {
        public int x;

        public V(Token token) {
            this.token = token;
        }

        public V(int n, int n2) {
            this.x = n2;
            this.token = new CommonToken(n);
        }

        public V(int n, Token token, int n2) {
            this.token = token;
            this.x = n2;
        }

        public String toString() {
            return (this.token != null ? this.token.getText() : "") + "<V>";
        }
    }
}

