% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dists.R
\name{get_dists}
\alias{get_dists}
\title{Get distance from longitude and latitude points}
\usage{
get_dists(lon, lat)
}
\arguments{
\item{lon}{chr string indicating name of longitude column in \code{dat_in}}

\item{lat}{chr string indicating name of latitude column in \code{dat_in} in \code{dat_in}}
}
\value{
A vector of distances with the length as the number of rows in \code{dat_in}
}
\description{
Get distance from longitude and latitude points
}
\details{
Used internally in \code{\link{get_elev_prof}} on objects returned by \code{\link{get_latlon}}
}
\examples{
\dontrun{
# get activity data
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))
my_acts <- get_activity_list(stoken)

# get the latest activity
acts_data <- compile_activities(my_acts)[1, ]

# get lat, lon
polyline <- acts_data$map.summary_polyline
latlon <- get_latlon(polyline, key = mykey)

# get distance
get_dists(latlon$lon, latlon$lat)
}
}
\author{
Daniel Padfield
}
\concept{notoken}
