% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSARP.r
\name{SearchOut.csv}
\alias{SearchOut.csv}
\title{SearchOut.csv - typical Data input file for \pkg{rSARP}}
\format{A data frame with 32 rows and 38 variables}
\source{
John Hutcheson
}
\description{
A dataset containing the sectors or search segments and key attributes of each
that will be searched, including the outputs. The variables are as follows:
}
\details{
\itemize{
  \item Sector. Name of the sector or grid to be searched.  Usually Alpha characters excluding I and O.
  \item Area. Area of the sector to be searched in Hectares or Acres.  Defaults to Hectares and requires parametric change in call to \code{searchme()} if Acres is used.
  \item AreaCoverage. Percentage of the the sector Area that was or will be covered. Typically used if the search teams are unable to
execute due to unforeseen hazards in the sector. If the value being given is negative, then the area is being searched for
the first time and bayesian treatments are skipped.
  \item Terrain. Keyword describing the terrain of the sector. Limited to use of a limited set of keywords. See guide for further specifics.
  \item TOD. Time of Day.  Keyword describing time of search and currently limited to Day or Night.
  \item WX. Weather keyword describing conditions during the search.  Currently limited to Normal or Snow6to8in.
  \item THours. Target duration Hours.  Hours team will be deployed for the search in the field not counting breaks or transportation time.
        If -1 entered for this value program will optimize using internal algorithms.
  \item TSearchers. Target Searchers.  Count of searchers, excluding non-searching supervisors, in the field assigned to that sector.
        If -1 entered for this value program will optimize using internal algorithms.
  \item TSpacing. Target Spacing.  The distance in meters between searchers planned for this sector search.
         If -1 entered for this value program will optimize using internal algorithms.
  \item AMDR. Average Maximum Detection Range in meters.  Initially estimated, then updated as measured AMDRs are reported in.
         If -1 entered for this value program will estimate based on Terrain values
  \item Rank. Total rank of the sector from sector ladder ranking exercise.  Use raw scores - software will normalize and handle appropriately.
  \item POScum. Cumulative Probability of Success for the sector in percentage points. Represents the POS that has already been 'harvested'
for that area.  If entered as negative number, will revise reports to indicate that no further searching is planned for this sector.
  \item fnCovered. Fraction of the planned area covered by the search.
  \item fnMissed. Fraction of the planned area missed by the search.
  \item AreaCov. Area Covered.  Area of the search seactor actually covered in Hectares or Acres.
  \item POC. Probability of Containment.  The normalized sector ranking.
  \item terspd. Terrain Speed. The estimated ground speed for the team in miles per hour based on terrain or given by planner constraints.
  \item terheads. Terrain Manhours. The estimated man hours to search the sector given spacing and speed constraints.
  \item FirstPass. Parameter indicating if the area to be cleared has already been searched or will be searched for the first time.
  \item ROThrs. Rule of Thumb hours. Estimated search man hours based on Model used in Kent County, primarily for urban search efforts.
  \item NHRSH. NASAR Man hours. Estimated man hours using NASAR rule of thumb.
  \item SAVHRS. Duration search hours saved if one additional person added to team to 'lengthen the line'. 
  \item ESW. Effective spacing width. Currently 1.5 times the AMDR but technically the length of Coverage in meters. Used to determine COV.
  \item COV. Coverage as a fraction. The TSpacing divided by ESW. Used to determine POD.
  \item POD. Probability of Detection as a fraction. Likelihood of detecting the object in the sector if the object is present.
  \item delspc. The change in spacing between team members if an additional person were added to the line but the overall length kept the same.
  \item dPOD. The change in the Probability of Detection that would result if the team spacing were changed by delspc.
  \item POS. Probability of Success. The probability that the subject would be found if present in that sector as a percent.
  \item dPOS. The change in POS in percent if the spacing between team members is changed by delspc.
  \item OPOScum. Overall cumulative Probability of Success. The running tally on POS by sector including bayiesian corrections.
  \item RTotlHeads. Running total heads. The number of searchers required to as a running total by sector to execute the plan.
  \item RTotlPOS. Running total POS. The percentage of POS accumulated if the plan is executed by sector as a running total.
  \item TotlArea. The running total area covered by this search plan in Hectares or Acres.
  \item AvgSpacing. The area averaged spacing between team members for all sectors this row and above.
  \item rPOC. The running Probability of Containment for all sectors this row and above.
  \item AvgAMDR. The running area averaged AMDR for all sectors this row and above. 
  \item POSm. THe probability of success that was missed due to the area missed.
}
}

