% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg.R
\name{tg.insertBoundary}
\alias{tg.insertBoundary}
\title{tg.insertBoundary}
\usage{
tg.insertBoundary(tg, tierInd, time, label = "")
}
\arguments{
\item{tg}{TextGrid object}

\item{tierInd}{tier index or "name"}

\item{time}{time of the new boundary}

\item{label}{[optional] label of the new interval}
}
\value{
TextGrid object
}
\description{
Inserts new boundary into interval tier. This creates a new interval, to
which we can set the \code{label} (optional argument).
}
\details{
There are more possible situations which influence where the new label
will be set.

a) New boundary into the existing interval (the most common situation):
   The interval is splitted into two parts. The left preserves the label
   of the original interval, the right is set to the new (optional) label.

b) On the left of existing interval (i.e., enlarging the tier size):
   The new interval starts with the new boundary and ends at the start
   of originally first existing interval. The label is set to the new
   interval.

c) On the right of existing interval (i.e., enlarging the tier size):
   The new interval starts at the end of originally last existing
   interval and ends with the new boundary. The label is set to the new
   interval.
   This is somewhat different behaviour than in a) and b) where the new
   label is set to the interval which is on the right of the new
   boundary. In c), the new label is set on the left of the new boundary.
   But this is the only logical possibility.

It is a nonsense to insert a boundary between existing intervals to a
position where there is no interval. This is against the basic logic of
Praat interval tiers where, at the beginning, there is one large empty
interval from beginning to the end. And then, it is divided to smaller
intervals by adding new boundaries. Nevertheless, if the TextGrid is
created by external programmes, you may rarely find such discontinuities.
In such a case, at first, use the \code{tgRepairContinuity()} function.
}
\examples{
tg <- tg.sample()
tg2 <- tg.insertNewIntervalTier(tg, 1, "INTERVALS")
tg2 <- tg.insertBoundary(tg2, "INTERVALS", 0.8)
tg2 <- tg.insertBoundary(tg2, "INTERVALS", 0.1, "Interval A")
tg2 <- tg.insertInterval(tg2, "INTERVALS", 1.2, 2.5, "Interval B")
\dontrun{
tg.plot(tg2)
}
}
\seealso{
\code{\link{tg.insertInterval}}, \code{\link{tg.removeIntervalLeftBoundary}}, \code{\link{tg.removeIntervalRightBoundary}}, \code{\link{tg.removeIntervalBothBoundaries}}, \code{\link{tg.boundaryMagnet}}, \code{\link{tg.duplicateTierMergeSegments}}
}
