% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walk_nested_dict.R
\name{walk_nested_dict}
\alias{walk_nested_dict}
\title{Recursively Walk Through a Nested Dictionary}
\usage{
walk_nested_dict(my_result, term, outputs = list(), depth = 0, maxdepth = 25)
}
\arguments{
\item{my_result}{The nested dictionary-like structure to search through.}

\item{term}{The term to search for within the nested dictionary.}

\item{outputs}{An initially empty list to store the results of the search, default is an empty list.}

\item{depth}{The current depth of the recursion, default is 0.}

\item{maxdepth}{The maximum depth to recurse, default is 25.
If exceeded, the function issues a warning and returns NULL.}
}
\value{
A list of values associated with the term found in the nested dictionary.
  Returns NULL if the term is not found or if maximum recursion depth is exceeded.
}
\description{
This function performs a recursive search through a nested dictionary-like structure in R,
looking for a specific term and collecting its values. It's useful for extracting specific pieces
of data from complex, deeply nested results.
}
