% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPBK.R
\name{dataPBK}
\alias{dataPBK}
\alias{dataPBK.data.frame}
\alias{nested_model}
\alias{nested_model.stanPBKdata}
\title{Create a list giving data and parameters to use in the model inference.}
\usage{
dataPBK(object, ...)

\method{dataPBK}{data.frame}(
  object,
  col_time = NA,
  col_replicate = NA,
  col_exposure = NA,
  col_compartment = NA,
  time_accumulation = NA,
  ku_nest = NA,
  ke_nest = NA,
  k_nest = NA,
  ...
)

nested_model(object)

\method{nested_model}{stanPBKdata}(object)
}
\arguments{
\item{object}{An object of class \code{stanPBKdata} (from \code{dataPBK()} function.}

\item{\dots}{Further arguments to be passed to generic methods}

\item{col_time}{Column name of the time column}

\item{col_replicate}{Column name of the replicate column}

\item{col_exposure}{Column name of the exposure column.}

\item{col_compartment}{Column names of the compartment column. If several columns,
give a vector with the column names.}

\item{time_accumulation}{A scalar giving accumulation time.}

\item{ku_nest}{Vector of binary (0 or 1) to select the uptake route. Use the
nested_model() on the \code{stanPBKdata} object to check it.}

\item{ke_nest}{Vector of binary (0 or 1) to select the excretion route. Use the
nested_model() on the \code{stanPBKdata} object to check it.}

\item{k_nest}{Matrix of binary (0 or 1) to select interaction routes. Use the
nested_model() on the \code{stanPBKdata} object to check it.}
}
\value{
A \code{list} with data and parameters require for model inference.
}
\description{
Create a list giving data and parameters to use in the model inference.
}
\examples{
# (1) load data file
data("dataCompartment4")
# (2) prepare data set
dataPBK_C4 <- dataPBK(
  object = dataCompartment4,
  col_time = "temps",
  col_replicate = "replicat",
  col_exposure = "condition",
  col_compartment = c("intestin", "reste", "caecum", "cephalon"),
  time_accumulation = 7)

# (1) load data file
data("dataCompartment4")
# (2) prepare data set
dataPBK_C4 <- dataPBK(
  object = dataCompartment4,
  col_time = "temps",
  col_replicate = "replicat",
  col_exposure = "condition",
  col_compartment = c("intestin", "reste", "caecum", "cephalon"),
  time_accumulation = 7)
# (3) check nesting
nested_model(dataPBK_C4)
# (2bis)
dataPBK_C42 <- dataPBK(
  object = dataCompartment4,
  col_time = "temps",
  col_replicate = "replicat",
  col_exposure = "condition",
  col_compartment = c("intestin", "reste", "caecum", "cephalon"),
  time_accumulation = 7,
  ku_nest = c(1,1,1,1), # No Change here
  ke_nest = c(1,1,1,1), # No Change here
  k_nest = matrix(c(
            c(0,1,1,1),
            c(0,0,1,1),
            c(0,0,0,0),
            c(0,0,0,0)),
            ncol=4,nrow=4,byrow=TRUE) # Remove 
  )
# (3bis) re-checking nesting
nested_model(dataPBK_C42)

}
