\name{designRaster}
\alias{designRaster}
\title{
Experimental Design on a Raster Image
}
\description{
It uses a design generated by the agricolae package in a raster image.
}
\usage{
designRaster(R,book)
}
\arguments{
  \item{R}{output object imageField}
  \item{book}{function output field book design.* agricolae}
}
\details{
The R object contains the following information: pixel coordinates and image layer information.

The outDesign object is generated by the design functions of the agricolae package
}
\value{
\item{design}{The matrix R of the image with the experimental design information}
\item{rasterField}{the R matrix of the image with the information of the bands and 
the characteristics of the experimental design}
}
\references{ 
Felipe de Mendiburu (2019). agricolae: Statistical Procedures for 
Agricultural Research. R package version 1.3-1. http://tarwi.lamolina.edu.pe/~fmendiburu\

Kwanchai A. Gomez, Arturo A. Gomez (1984). Statistical Procedures for Agricultural Research. 
John Wiley & Sons, new York.
}

\author{
Felipe de Mendiburu
}
\seealso{\code{\link{externalPoint}}, \code{\link{fixedPoint}}, \code{\link{fourPoint}}, 
\code{\link{imageField}}, \code{\link{borderPoint}}, \code{\link{movePlot}}
}
\examples{
library(rPAex)
oldpar<-par(mar=c(2,2,3,2),cex=0.8)
# r = simulated raster image data
prg1 <- system.file("examples/Ex-01.R", package="rPAex")
source(prg1)
r<-data1()

# Alpha design, r-raster image 
trt<-1:12
t <- length(trt)
# size block k
k<-3
# Blocks s
s<-t/k
# replications r =2
outdesign<- agricolae::design.alpha(trt,k=3,r=2,serie=1)
r1<-subset(outdesign$book, replication==1)
r2<-subset(outdesign$book, replication==2)
#--------
raster::image(r,main="alpha design in the image\n
with the distribution of treatments",col=col2rgb(10))
#P<-locator(3)
p1<-list(x=c(4.27, 35.42, 47.49),y=c(68.12, 70.82, 23.63))
q1<-fourPoint(p1)
p2<-list(x=c(50.27, 81.42, 93.49),y=c(68.12, 70.82, 23.63))
q2<-fourPoint(p2)
polygon(q1,lwd=3,lty=2,border=colors()[51])
polygon(q2,lwd=3,lty=2,border=colors()[51])
R1<-imageField(r, P=q1, nPl=4, nPw=3, long=10, wide=9,col=colors()[18])
R2<-imageField(r, P=q2, nPl=4, nPw=3, long=10, wide=9,col=colors()[18])
q1<-designRaster(R=R1$Qbase,book=r1)$design
q2<-designRaster(R=R2$Qbase,book=r2)$design
text(q1[,6],q1[,7],q1[,4])
text(q2[,6],q2[,7],q2[,4])
par(oldpar)
}
\keyword{design}

