% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubin_analysis.R
\name{combine}
\alias{combine}
\title{Estimate and combine regression models from multiply-imputed data}
\usage{
combine(formula, df_list, dof_adjust = TRUE, ...)
}
\arguments{
\item{formula}{A formula, or character string coercible to a formula}

\item{df_list}{A list, containing data.frames or objects coercible to data.frames}

\item{dof_adjust}{Boolean, indicating whether or not to apply the Rubin and Barnard (1999) degrees of freedom adjustment for small-samples}

\item{...}{Further arguments passed onto \code{glm()}}
}
\value{
Data.frame of combined model results.
}
\description{
\code{combine()} calculates \emph{m} individual regression models, then applies "Rubin's Rules" to produce a single, combined estimate of the regression parameters and uncertainty.
}
\examples{
set.seed(89)
test_dfs <- lapply(1:5, function (x) data.frame(a = rnorm(1000),
                                                b = runif(1000),
                                                c = 2*rnorm(1000)))

midas_res <- combine("a ~ b + c", df_list = test_dfs)
}
\keyword{import}
