% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_rand.R
\name{shuffle}
\alias{shuffle}
\title{Shuffle MEA data}
\usage{
shuffle(mea, size)
}
\arguments{
\item{mea}{an object of class \code{MEAlist} (see function \code{\link{readMEA}}).}

\item{size}{integer. The number of combinations to be returned.}
}
\value{
an object of class \code{MEAlist} containing randomly combined dyads.
}
\description{
This function recombines the s1 and s2 motion energy time-series between all \code{MEA} objects in the supplied list.
It is typically used to compare genuine synchrony of real data with pseudosynchrony of shuffled (recombined) data.
}
\details{
The shuffling process first creates all possible combinations between s1 and s2 of all \code{MEA} objects in the supplied list,
then removes the original pairings, and finally extracts the desired numbers of dyads without replacement.

Note: all the ccf data, if present, are discarded from the shuffled objects and have to be calculated again using \code{\link{MEAccf}}
}
\examples{
## read the first 4 minutes of the normal sample
##   (intake interviews of patients that carried on therapy)
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_normal <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)
mea_normal <- setGroup(mea_normal, "normal")

## Create a shuffled sample
mea_rand = shuffle(mea_normal, 50)

summary(mea_rand)
}
