% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/chullLiDAR2D.r
\name{chullLiDAR2D}
\alias{chullLiDAR2D}
\title{2D Convex hull of individual tree LiDAR-derived point cloud}
\usage{
chullLiDAR2D(xyid)
}
\arguments{
\item{xyid}{A 3-column matrix with the x, y coordinates and points id of the LiDAR point cloud.}
}
\value{
Returns A list with components "chullPolygon" and "chullArea", giving the polygon and area  of the convex hull.
}
\description{
Compute and plot the 2D convex hull of individual tree LiDAR-derived point cloud
}
\examples{
# Importing LAS file:
LASfile <- system.file("extdata", "LASexample1.las", package="rLiDAR")

# Reading LAS file
LAS<-readLAS(LASfile,short=TRUE)

# Height subsetting the data
xyz<-subset(LAS[,1:3],LAS[,3] >= 1.37)

# Getting LiDAR clusters
set.seed(1)
clLAS<-kmeans(xyz, 32)

# Set the points id
id<-as.factor(clLAS$cluster)

# Set the xyid input
xyid<-cbind(xyz[,1:2],id)

# Compute the LiDAR convex hull of the clusters
chullTrees<-chullLiDAR2D(xyid)

# Plotting the LiDAR convex hull
library(sp)
plot(SpatialPoints(xyid[,1:2]),cex=0.5,col=xyid[,3])
plot(chullTrees$chullPolygon,add=TRUE, border='green')

# Get the ground-projected area of LiDAR convex hull
chullList<-chullTrees$chullArea
summary(chullList) # summary
}
\author{
Carlos Alberto Silva
}
\references{
\emph{grDevices} package,see \code{\link[grDevices]{chull}}.
}

