% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.richness.R
\name{msc.richness}
\alias{msc.richness}
\title{Minicircle Sequence Cluster richness}
\usage{
msc.richness(clustmatrices, samples, groups)
}
\arguments{
\item{clustmatrices}{a list of cluster matrices obtained from the msc.matrix function. Each cluster matrix represents the presence or absence of MSCs in each sample.}

\item{samples}{a vector containing the names of the samples.}

\item{groups}{a vector specifying the group (e.g., species) to which each sample belongs.}
}
\value{
\item{table}{a table summarizing the number of MSCs per sample at different percent identities. The table provides an overview of the estimated minicircle richness in each sample across the MPIs.}
\item{plot}{a boxplot visualizing the minicircle richness across samples. The boxplot represents the distribution of richness estimates in each sample over the range of MPIs considered.}
}
\description{
The msc.richness function calculates the measure of minicircle richness per sample by estimating the number of Minicircle Sequence Classes (MSCs) in each sample. It takes into account different minimum percent identities (MPIs) and returns a table of richness estimates per sample and per MPI. Additionally, it generates a boxplot that illustrates the minicircle richness across samples based on the estimated MSCs over a range of MPIs.
}
\examples{
require(ggplot2)
data(matrices)
data(exData)

#### run function
richness <- msc.richness(matrices, samples = exData$samples, groups = exData$species)

apply(richness$table[which(richness$table$group=="L. peruviana"),-(1:2)], 2, mean)
apply(richness$table[which(richness$table$group=="L. braziliensis"),-(1:2)], 2, mean)
apply(richness$table[which(richness$table$group=="hybrid"),-(1:2)], 2, mean)  

#### visualize results
barplot(richness$table[,"id93"], names.arg = richness$table[,1],
        las=2, cex.names=0.4, main="N of MSC at id 93")

#### adjust plot
richness$plot + ggtitle("MSC richness across \% id") + 
                theme(axis.text.x = element_text(angle=45, hjust=1))

### show results of subset 
table(exData$species)
hybrid <- which(exData$species=="hybrid")
# richness.subset <- msc.richness(matrices, samples = exData$samples[hybrid], 
#                                 groups = exData$species[hybrid])

}
