% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{GV}
\alias{GV}
\title{Calculate all glycemic variability metrics}
\usage{
GV(
  x,
  times,
  unit = "mg",
  m_index = 120,
  k = 60,
  s = 1,
  conga_n = 1,
  interval = 1,
  thresh = 100,
  event_thresh = 55
)
}
\arguments{
\item{x}{vector of glucose readings}

\item{times}{vector of corresponding times, in minutes}

\item{unit}{"mg" if the units are mg/dL or "mmol" if the units are mmol/L. Null value is "mg".}

\item{m_index}{a value to be considered a 'standard' blood glucose value for calculation of M-value, in mg/dL. Null value is 120.}

\item{k}{length of time (in minutes) used to find partners. Null value is 60.}

\item{s}{number of minutes of slack used when searching for partners. Null value is 1.}

\item{conga_n}{number of hours between "partner" observations. Null value is 1.}

\item{interval}{size (in hours) of the moving window to be used if overall is false. Null value is 1.}

\item{thresh}{threshold above (or below) which you wish to calculate the AUC. Default is 100.}

\item{event_thresh}{glucoses below this threshold are considered as part of an episode. Default is 55}
}
\value{
A data frame containing the entire suite of rGV metrics for the given dataset.
}
\description{
Calculate all glycemic variability metrics
}
\examples{
GV(x=c(rep(100, 10), rep(120, 10), 105, 85), times=seq(0, 1260, 60), unit='mg',
m_index=120, k=60, s=1, conga_n=1, interval=1, thresh=100, event_thresh=55)
}
