% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tools.R
\name{merge.rFerns}
\alias{merge.rFerns}
\title{Merge two random ferns models}
\usage{
\method{merge}{rFerns}(x, y, dropModel = FALSE,
  ignoreObjectConsistency = FALSE, trueY = NULL, ...)
}
\arguments{
\item{x}{Object of a class \code{rFerns}; a first model to be merged.}

\item{y}{Object of a class \code{rFerns}; a second model to be merged.
Can also be \code{NULL}, \code{x} is immediately returned in that case.
Has to have be built on the same kind of training data as \code{x}, with the same depth.}

\item{dropModel}{If \code{TRUE}, model structure will be dropped to save size.
This disallows prediction using the merged model, but retains importance and OOB approximations.}

\item{ignoreObjectConsistency}{If \code{TRUE}, merge will be done even if both models were built on a different sets of objects.
This drops OOB approximations.}

\item{trueY}{Copy of the training decision, used to re-construct OOB error and confusion matrix.
Can be omitted, OOB error and confusion matrix will disappear in that case; ignored when \code{ignoreObjectConsistency} is \code{TRUE}.}

\item{...}{Ignored, for S3 gerneric/method consistency.}
}
\value{
An object of class \code{rFerns}, which is a list with the  following components:
\item{model}{The merged model in case both \code{x} and \code{y} had model structures included and \code{dropModel} was \code{FALSE}.
Otherwise \code{NULL}.}
\item{oobErr}{OOB approximation of accuracy, if can be computed.
Namely, when \code{oobScores} could be and \code{trueY} is provided.}
\item{importance}{The merged importance scores in case both \code{x} and \code{y} had importance calculated.
Shadow importance appears only if both models had it enabled.}
\item{oobScores}{OOB scores, if can be computed; namely if both models had it calculated and \code{ignoreObjectConsistency} was not used.}
\item{oobPreds}{A vector of OOB predictions of class for each object in training set, if can be computed.}
\item{oobConfusionMatrix}{OOB confusion matrix, if can be computed.
Namely, when \code{oobScores} could be and \code{trueY} is provided.}
\item{timeTaken}{Time used to train the model, calculated as a sum of training times of \code{x} and \code{y}.}
\item{parameters}{Numerical vector of three elements: \code{classes}, \code{depth} and \code{ferns}.}
\item{classLabels}{Copy of \code{levels(Y)} after purging unused levels.}
\item{isStruct}{Copy of the train set structure.}
\item{merged}{Set to \code{TRUE} to mark that merging was done.}
}
\description{
This function combines two compatible (same decision, same training data structure and same depth) models into a single ensemble.
It can be used to distribute model training, perform it on batches of data, save checkouts or precisely investigate its course.
}
\note{
In case of different training object sets were used to build the merged models, merged importance is calculated but mileage may vary; for substantially different sets it may become biased.
Your have been warned.

Shadow importance is only merged when both models have shadow importance and the same \code{consistentSeed} value; otherwise shadow importance would be biased down.

The order of objects in \code{x} and \code{y} is not important; the only exception is merging with \code{NULL}, in which case \code{x} must be an \code{rFerns} object for R to use proper merge method.
}
\examples{
set.seed(77)
#Fetch Iris data
data(iris)
#Build models
rFerns(Species~.,data=iris)->modelA
rFerns(Species~.,data=iris)->modelB
modelAB<-merge(modelA,modelB);
print(modelA);
print(modelAB);
}
\author{
Miron B. Kursa
}

