% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/better_model.R
\name{better_model}
\alias{better_model}
\title{better_model helper function}
\usage{
better_model(
  statstable_pre,
  statstable_post_hyperbolic = NULL,
  statstable_post_cubic = NULL,
  selection_method = "SSE"
)
}
\arguments{
\item{statstable_pre}{A data.table object, containing the output of
\code{statisticsList_()} of the calculated regression parameters (form
the provided calibration data).}

\item{statstable_post_hyperbolic}{A data.table object, containing
the output of \code{statisticsList_()} of the calculated regression
parameters form the calibration data corrected with hyperbolic regression.}

\item{statstable_post_cubic}{A data.table object, containing the output
of \code{statisticsList_()} of the calculated regression parameters form
the calibration data corrected with cubic regression.}

\item{selection_method}{A character string. The method used to select the
regression algorithm to correct the respective CpG site. This is by
default the sum of squared errors ("SSE"). The second option is
"RelError", which selects the regression method based on the theoretical
relative error after correction. This metric is calculated by correcting
the calibration data with both the hyperbolic regression and the cubic
regression and using them again as input data to calculate the 'goodness
of fit'-metrics.}
}
\value{
The function returns a data.table with 4 columns, the last column
  being named 'better_model', which indicates in a binary manner,
  if the hyperbolic model (better_model = 0) or the cubic model
  (better_model = 1) result in a 'better' `SSE` or `RelError` respectively.
}
\description{
Internal function to select the better model between
  hyperbolic regression and cubic regression.
}
\examples{
\donttest{
# define list object to save all data
rv <- list()
rv$minmax <- TRUE
rv$selection_method <- "RelError"
rv$sample_locus_name <- "Test"
rv$seed <- 1234

# define logfilename
logfilename <- paste0(tempdir(), "/log.txt")

# import experimental file
exp_type_1 <- rBiasCorrection::example.data_experimental
rv$fileimport_experimental <- exp_type_1$dat

# import calibration file
cal_type_1 <- rBiasCorrection::example.data_calibration
rv$fileimport_calibration <- cal_type_1$dat
rv$vec_cal <- cal_type_1$vec_cal


# perform regression
regression_results <- regression_utility(
  rv$fileimport_calibration,
  "Testlocus",
  locus_id = NULL,
  rv = rv,
  mode = NULL,
  logfilename,
  minmax = rv$minmax,
  seed = rv$seed
)

# extract regression results
rv$result_list <- regression_results$result_list

# get regression statistics
rv$reg_stats <- statistics_list(
  rv$result_list,
  minmax = rv$minmax
)

# select the better model based on the sum of squared errrors ("SSE")
rv$choices_list <- better_model(
  statstable_pre = rv$reg_stats,
  selection_method = "SSE"
)
}

}
