% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTree.R
\name{plot.datBDAT}
\alias{plot.datBDAT}
\title{Plot taper curve of a tree}
\usage{
\method{plot}{datBDAT}(x, bark = NULL, col.bark = NULL, legend = FALSE, assort = NULL, ...)
}
\arguments{
\item{x}{an object of class 'datBDAT'}

\item{bark}{either NULL or logical; if TRUE taper curve over bark is plotted,
if FALSE taper curve under bark is plotted; if NULL, both are plotted}

\item{col.bark}{color to be used for plot of bark, if plot of taper curve
over and under bark is requested}

\item{legend}{logical, if legend should be added}

\item{assort}{assortments produced by \code{getAssortment(, value="merge")}}

\item{...}{further arguments for \code{plot} and \code{points}}
}
\value{
No return value, called for side effects
}
\description{
creating a plot of the taper curve of a tree, over or under bark
}
\details{
Creates graphics of the taper curve of trees. Either over bark or
under bark, or both. Elements design can partly be chosen. If assortments are
given, these are added to the plot. Doing that, the assortment bottom and top
position is indicated by a vertical line and mid-diameter is shown as a point
with vertical dashed line. N.B. the mid-diameter shown is under bark and
rounded downwards for 0.5 cm if mid-diameter < 20 and for 0.75 cm if bigger.
Assortment volume is calculated using this diameter according to the legal
rules for roundwood assortments (formerly german Forst-HKS and now RVR).
Additionally, assortment names are indicated.
One can provide assortment names in a column of \code{assort} named
'assortname', which will be used if available, otherwise the 'Sort'-column
 will be used. See Examples.
}
\examples{
## plotting the taper curve of a tree
oldpar <- par(no.readonly = TRUE)
par(mfrow = c(1, 1))
t <- data.frame(spp = 1, D1 = 40, H = 35)
tree <- buildTree(tree = t)
plot(tree, type = "l", las = 1, legend = TRUE)
plot(tree, bark = TRUE, las = 1)
plot(tree, bark = FALSE, las = 1)
t <- data.frame(spp = c(1, 1), D1 = c(40, 35), H = c(35, 30))
tree <- buildTree(tree = t)
plot(tree, bark = FALSE, las = 1, legend = TRUE)
plot(tree, bark = TRUE, las = 1, legend = TRUE)

t <- data.frame(spp = c(1, 8), D1 = 40, H = 35)
tree <- buildTree(tree = t)
plot(tree, bark = NULL, las = 1, col.bark = "blue", legend = TRUE)
plot(tree[1, ], main = getSpeciesCode(tree[1, ]$spp, out = "long"))
plot(tree[2, ], main = getSpeciesCode(tree[2, ]$spp, out = "scientific"))
par(mfrow = c(2, 1))
plot(tree, bark = TRUE, las = 1)

## now add assortments into taper curve
par(mfrow = c(1, 1))
ass <- getAssortment(tree, sort = list(lX = 1, fixN = 2, fixL = 4, fixA = 10))
plot(tree, assort = ass)
plot(tree, bark = FALSE, assort = ass)
plot(tree, bark = FALSE, assort = ass, legend = TRUE)
plot(tree[1, ], assort = ass[ass$tree == 1, ], main = "first tree in subset")
plot(tree[2, ], assort = ass[ass$tree == 2, ], main = "second tree in subset")

## adding own assortment labels using column 'assortname'
ass$assortname <- ifelse(grepl("Fix", ass$Sort), paste0("Fix:", ass$length), ass$Sort)
plot(tree, assort = ass)
par(oldpar)
}
