% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDATVOLDHMR.R
\name{BDATVOLDHMR}
\alias{BDATVOLDHMR}
\title{Calculate (coarse) wood volume over bark of a tree up to given diameter}
\usage{
BDATVOLDHMR(BDATArtNr, D1, H1 = 1.3, D2 = 0, H2 = 0, H, DHGrz = 7, SekLng = 2)
}
\arguments{
\item{BDATArtNr}{numeric vector of species code; see
\code{\link{getSpeciesCode}}.}

\item{D1}{first measured diameter of tree [cm], e.g. diameter in breast
height.}

\item{H1}{measurement height of \code{D1} [m]}

\item{D2}{second measured diameter of tree, see \code{\link{buildTree}} for
details on how to specify different taper forms}

\item{H2}{measurement height of D2, see \code{\link{buildTree}} for details
on how to specify different taper forms}

\item{H}{total tree height [m]}

\item{DHGrz}{diameter over bark up to which volume should be calculated}

\item{SekLng}{length of section over which the integral of taper form should
be applied, defaults to 2.0m.}
}
\value{
vector of same length as input variables transformed into a
data.frame, returning the required volume in cubic meter.
}
\description{
BDAT-Function to get (coarse) wood volume over bark up to a
given diameter of one or many trees.
}
\details{
Volume is calculated using BDAT Fortran routines. In particular,
\code{BDATVOLDHMR} internally calls \code{\link{BDATVOLABMR}} with parameter
\code{A = 0}, i.e. volume is calculated from forest floor up to given
diameter, which itself is transformed into height \code{B}.
}
\examples{
## simple call of function, with all parameters given
BDATVOLDHMR(1, 30, 1.3, 0, 0, 25, 7, 2.0)
BDATArtNr <- 1
D1 <- 30
H1 <- 1.3
D2 <- 0
H2 <- 0
H <- 25
DHGrz <- 7

## same using variables
BDATVOLDHMR(BDATArtNr = BDATArtNr, D1 = D1, H1 = H1, D2 = D2, H2 = H2, H = H, DHGrz = DHGrz)

## calling with a subset of tree characteristics
## german species names, abbreviated
BDATVOLDHMR(getSpeciesCode(c("Fi", "Bu")), 30, 0, 0, 0, H = 25, DHGrz = 7)
## english abbreviation
BDATVOLDHMR(getSpeciesCode(c("NS", "BE")), 30, 0, 0, 0, H = 25, DHGrz = 7)
}
\seealso{
\code{\link{BDATVOLDHOR}} for BDAT routine calculating volume under
bark, \code{\link{getVolume}} for a function with a convenient english name,
more options and including a bark switch.
}
