% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_AmObject.R, R/class_AxisBase.R, R/class_ValueAxis.R, R/class_TrendLine.R, R/class_Title.R, R/class_AmChart.R, R/class_StockPanel.R, R/class_StockEvent.R, R/class_PeriodSelector.R, R/class_Label.R, R/class_Guide.R, R/class_GaugeAxis.R, R/class_GaugeBand.R, R/class_GaugeArrow.R, R/class_DataSet.R, R/class_ChartScrollbar.R, R/class_ChartCursor.R, R/class_AmLegend.R, R/class_AmGraph.R, R/class_AmBalloon.R, R/class_CategoryAxis.R, R/class_AmStockChart.R, R/class_DataSetSelector.R
\docType{methods}
\name{listProperties}
\alias{listProperties}
\alias{listProperties,AmBalloon-method}
\alias{listProperties,AmChart-method}
\alias{listProperties,AmGraph-method}
\alias{listProperties,AmLegend-method}
\alias{listProperties,AmObject-method}
\alias{listProperties,AmStockChart-method}
\alias{listProperties,AxisBase-method}
\alias{listProperties,CategoryAxis-method}
\alias{listProperties,ChartCursor-method}
\alias{listProperties,ChartScrollbar-method}
\alias{listProperties,DataSet-method}
\alias{listProperties,DataSetSelector-method}
\alias{listProperties,GaugeArrow-method}
\alias{listProperties,GaugeAxis-method}
\alias{listProperties,GaugeBand-method}
\alias{listProperties,Guide-method}
\alias{listProperties,Label-method}
\alias{listProperties,PeriodSelector-method}
\alias{listProperties,StockEvent-method}
\alias{listProperties,StockPanel-method}
\alias{listProperties,Title-method}
\alias{listProperties,TrendLine-method}
\alias{listProperties,ValueAxis-method}
\title{List properties of an S4 object}
\usage{
listProperties(.Object)

\S4method{listProperties}{AmObject}(.Object)

\S4method{listProperties}{AxisBase}(.Object)

\S4method{listProperties}{ValueAxis}(.Object)

\S4method{listProperties}{TrendLine}(.Object)

\S4method{listProperties}{Title}(.Object)

\S4method{listProperties}{AmChart}(.Object)

\S4method{listProperties}{StockPanel}(.Object)

\S4method{listProperties}{StockEvent}(.Object)

\S4method{listProperties}{PeriodSelector}(.Object)

\S4method{listProperties}{Label}(.Object)

\S4method{listProperties}{Guide}(.Object)

\S4method{listProperties}{GaugeAxis}(.Object)

\S4method{listProperties}{GaugeBand}(.Object)

\S4method{listProperties}{GaugeArrow}(.Object)

\S4method{listProperties}{DataSet}(.Object)

\S4method{listProperties}{ChartScrollbar}(.Object)

\S4method{listProperties}{ChartCursor}(.Object)

\S4method{listProperties}{AmLegend}(.Object)

\S4method{listProperties}{AmGraph}(.Object)

\S4method{listProperties}{AmBalloon}(.Object)

\S4method{listProperties}{CategoryAxis}(.Object)

\S4method{listProperties}{AmStockChart}(.Object)

\S4method{listProperties}{DataSetSelector}(.Object)
}
\arguments{
\item{.Object}{any class object of the package}
}
\value{
A list containing all the chart's properties.
}
\description{
Each S4 class implements the method to list its properties
(usefull to update complex properties).
}
\examples{
amChart(type = "serial")

library(pipeR)
\dontshow{
valueAxis(axisTitleOffset = 12, tickLength = 10) \%>>\% listProperties \%>>\% class
}
valueAxis(axisTitleOffset = 12, tickLength = 10, axisTitleOffset = 12) \%>>\%
addGuide(fillAlpha = .4, adjustBorderColor = TRUE, gridThickness = 1) \%>>\% listProperties

trendLine(initialValue = 1, valueAxis = valueAxis(axisTitleOffset = 12, tickLength = 10))
title(text = "foo")
# --- signature 'AmChart'
listProperties(amChart(test = 1))


stockPanel(drawnOnAxis = "axis1") 
listProperties(stockEvent())
listProperties(periodSelector(fillAlpha = .4, value = 1))
listProperties(label(text = "balloonText"))
# --- signature 'Guide'
lapply(list(guide(fillAlpha = .4, value = 1), guide(fillAlpha = .5)), listProperties)
listProperties(gaugeAxis())
# --- signature 'GaugeBand'
lapply(list(gaugeBand(fillAlpha = .4, value = 1), gaugeBand(fillAlpha = .5)), listProperties)

lapply(list(gaugeArrow(alpha = .4, value = 1), gaugeArrow(alpha = .5)), listProperties)
listProperties(chartScrollbar(enabled = TRUE))
new("ChartCursor", oneBalloonOnly = TRUE)

# --- signature 'AmLegend'
listProperties(amLegend(useGraphSettings = TRUE))

# --- signature 'AmGraph'
listProperties(amGraph(balloonText = "toto", type = "type", valueField = "valueField"))
listProperties(amGraph(balloonText = "toto", type = "type"))

amBalloon(adjustBorderColor = TRUE)
\dontshow{
library(pipeR)
categoryAxis(ignoreAxisWidth = TRUE) \%>>\% listProperties() \%>>\% class
categoryAxis(ignoreAxisWidth = TRUE) \%>>\% listProperties() \%>>\% length
categoryAxis(ignoreAxisWidth = TRUE) \%>>\% setGridPosition("start") \%>>\% listProperties()
}

# --- signature 'AmStockChart'
listProperties(amStockChart(test = 1))

dataSetSelector(position = "left")
}

