% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_AmStockChart.R, R/class_AmStockChart_setters.R
\docType{methods}
\name{initialize,AmStockChart-method}
\alias{addComparedDataSet}
\alias{addComparedDataSet,AmStockChart,DataSetOrMissing-method}
\alias{addDataSet}
\alias{addDataSet,AmStockChart,DataSetOrMissing-method}
\alias{addPanel}
\alias{addPanel,AmStockChart,StockPanelOrMissing-method}
\alias{amStockChart}
\alias{initialize,AmStockChart-method}
\alias{setBalloon,AmStockChart,AmBalloonOrMissing-method}
\alias{setCategoryAxesSettings}
\alias{setCategoryAxesSettings,AmStockChart-method}
\alias{setChartCursorSettings}
\alias{setChartCursorSettings,AmStockChart-method}
\alias{setChartScrollbarSettings}
\alias{setChartScrollbarSettings,AmStockChart,ChartScrollbarOrMissing-method}
\alias{setComparedDataSets}
\alias{setComparedDataSets,AmStockChart-method}
\alias{setDataSetSelector}
\alias{setDataSetSelector,AmStockChart-method}
\alias{setDataSets}
\alias{setDataSets,AmStockChart-method}
\alias{setLegendSettings}
\alias{setLegendSettings,AmStockChart-method}
\alias{setMainDataSet}
\alias{setMainDataSet,AmStockChart,DataSetOrMissing-method}
\alias{setPanels}
\alias{setPanels,AmStockChart,list-method}
\alias{setPanelsSettings}
\alias{setPanelsSettings,AmStockChart-method}
\alias{setPeriodSelector}
\alias{setPeriodSelector,AmStockChart,PeriodSelectorOrMissing-method}
\alias{setStockEventsSettings}
\alias{setStockEventsSettings,AmStockChart-method}
\alias{setValueAxesSettings}
\alias{setValueAxesSettings,AmStockChart-method}
\title{Initializes an AmStockChart}
\usage{
\S4method{initialize}{AmStockChart}(.Object, balloon, comparedDataSets,
  dataSets, dataSetSelector, mainDataSet, panels, periodSelector, theme, ...)

amStockChart(balloon, comparedDataSets, dataSets, dataSetSelector, mainDataSet,
  panels, periodSelector, theme, ...)

\S4method{setBalloon}{AmStockChart,AmBalloonOrMissing}(.Object,
  amBalloon = NULL, ...)

setCategoryAxesSettings(.Object, ...)

\S4method{setCategoryAxesSettings}{AmStockChart}(.Object, ...)

setChartCursorSettings(.Object, ...)

\S4method{setChartCursorSettings}{AmStockChart}(.Object, ...)

setChartScrollbarSettings(.Object, chartScrollbarSettings = NULL, ...)


  \S4method{setChartScrollbarSettings}{AmStockChart,ChartScrollbarOrMissing}(.Object,
  chartScrollbarSettings = NULL, ...)

setComparedDataSets(.Object, comparedDataSets)

\S4method{setComparedDataSets}{AmStockChart}(.Object, comparedDataSets)

addComparedDataSet(.Object, dataSet = NULL, ...)

\S4method{addComparedDataSet}{AmStockChart,DataSetOrMissing}(.Object,
  dataSet = NULL, ...)

setDataSets(.Object, dataSets)

\S4method{setDataSets}{AmStockChart}(.Object, dataSets)

addDataSet(.Object, dataSet = NULL, ...)

\S4method{addDataSet}{AmStockChart,DataSetOrMissing}(.Object, dataSet = NULL,
  ...)

setDataSetSelector(.Object, dataSetSelector = NULL, ...)

\S4method{setDataSetSelector}{AmStockChart}(.Object, dataSetSelector = NULL,
  ...)

setLegendSettings(.Object, ...)

\S4method{setLegendSettings}{AmStockChart}(.Object, ...)

setMainDataSet(.Object, dataSet = NULL, ...)

\S4method{setMainDataSet}{AmStockChart,DataSetOrMissing}(.Object,
  dataSet = NULL, ...)

setPanels(.Object, panels)

\S4method{setPanels}{AmStockChart,list}(.Object, panels)

addPanel(.Object, panel = NULL, ...)

\S4method{addPanel}{AmStockChart,StockPanelOrMissing}(.Object, panel = NULL,
  ...)

setPanelsSettings(.Object, ...)

\S4method{setPanelsSettings}{AmStockChart}(.Object, ...)

setPeriodSelector(.Object, periodSelector = NULL, ...)

\S4method{setPeriodSelector}{AmStockChart,PeriodSelectorOrMissing}(.Object,
  periodSelector = NULL, ...)

setStockEventsSettings(.Object, ...)

\S4method{setStockEventsSettings}{AmStockChart}(.Object, ...)

setValueAxesSettings(.Object, ...)

\S4method{setValueAxesSettings}{AmStockChart}(.Object, ...)
}
\arguments{
\item{.Object}{\linkS4class{AmStockChart}.}

\item{balloon}{\linkS4class{AmBalloon}.}

\item{comparedDataSets}{\code{list} of \linkS4class{DataSet}.
Properties of data sets selected for comparing.}

\item{dataSets}{\code{list} of \linkS4class{DataSet}.
Each element must be a list of DataSet properties.}

\item{dataSetSelector}{\code{list} of \linkS4class{DataSetSelector}.
You can add it if you have more than one data set and want users
to be able to select/compare them.}

\item{mainDataSet}{\linkS4class{DataSet}.
Data set selected as main.}

\item{panels}{\code{list} of \linkS4class{StockPanel}.}

\item{periodSelector}{\linkS4class{PeriodSelector}.
You can add it if you want user's to be able to enter
date ranges or zoom chart with predefined period buttons.}

\item{theme}{\code{character}.}

\item{...}{other properties of AmStockChart.}

\item{amBalloon}{\linkS4class{AmBalloon}.
Argument for method \code{setBalloon}.}

\item{chartScrollbarSettings}{\linkS4class{ChartScrollbar}.
If you change a property after the chart is initialized,
you should call stockChart.validateNow() method in order for it to work.
If there is no default value specified, default value of ChartScrollbar class will be used.}

\item{dataSet}{\linkS4class{DataSet}.}

\item{panel}{\linkS4class{StockPanel}.}
}
\value{
An object of class \linkS4class{AmStockChart}.
}
\description{
Method to initialize any S4 class provided by the package.
}
\details{
CategoryAxesSettings sets common settings for all CategoryAxes of StockPanels.
If you change a property after the chart is initialized,
you should call stockChart.validateNow() method.
If there is no specified value, default value of CategoryAxis class will be used.
you should get this axis from the chart and set properties to this object.

ChartCursorSettings sets settings for chart cursor.
If you change a property after the chart is initialized,
you should call stockChart.validateNow() method.
If there is no specified value, default value of ChartCursor class will be used.

You can add it if you have more than one data set and want users
to be able to select/compare them.
}
\examples{
# --- method 'initialize'
new("AmStockChart", theme = "dark")

# --- constructor
amStockChart()

setBalloon(.Object = amStockChart(), gridPosition = "start")
# ---
setCategoryAxesSettings(.Object = amStockChart(), gridPosition = "start")
# ---
setChartCursorSettings(.Object = amStockChart(), oneBallOnly = TRUE)
# ---
amchart <- setChartScrollbarSettings(.Object = amStockChart(), enabled = TRUE)
print(amchart)

# equivalent to:
chartScrollbarSettings_obj <- chartScrollbarSettings()
setChartScrollbarSettings(.Object = amStockChart(),
                          chartScrollbarSettings = chartScrollbarSettings_obj)
# ---
comparedDataSets_ls <- list(dataSet(compared = TRUE), dataSet(compared = TRUE))
setComparedDataSets(.Object = amStockChart(), comparedDataSets = comparedDataSets_ls)
addComparedDataSet(.Object = amStockChart(), compared = TRUE)
# ---
dataSets_ls <- list(dataSet(compared = FALSE), dataSet(compared = FALSE))
setDataSets(.Object = amStockChart(), dataSets = dataSets_ls)
# ---
addDataSet(.Object = amStockChart(), compared = FALSE)
# equivalent to:
dataSet_obj <- dataSet(compared = FALSE)
addDataSet(.Object = amStockChart(), dataSet = dataSet_obj)
# ---
print(setDataSetSelector(.Object = amStockChart(), width = 180))

# equivalent to:
dataSetSelector_obj <- dataSetSelector(width = 180)
print(setDataSetSelector(.Object = amStockChart(),
                         dataSetSelector = dataSetSelector_obj))

setLegendSettings(.Object = amStockChart(), equalWidths = TRUE)
setMainDataSet(.Object = amStockChart(), showInCompare = TRUE)
panels_ls <- list(stockPanel(compared = TRUE), stockPanel(compared = TRUE))
setPanels(.Object = amStockChart(), panels = panels_ls)
addPanel(.Object = amStockChart(), allowTurningOff = TRUE)
# equivalent to:
panel_obj <- panel(allowTurningOff = TRUE)
addPanel(.Object = amStockChart(), panel = panel_obj)
setPanelsSettings(.Object = amStockChart(), backgroundAlpha = 0)
setPeriodSelector(.Object = amStockChart(), dateFormat = "DD-MM-YYYY")
setStockEventsSettings(.Object = amStockChart(), backgroundAlpha = 1)
setValueAxesSettings(.Object = amStockChart(), autoGridCount = "TRUE")
}

