/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.api.ProfileResponse;
import com.conveyal.r5.point_to_point.builder.PointToPointQuery;
import com.conveyal.r5.profile.ProfileRequest;
import com.conveyal.r5.transit.TransportNetwork;
import java.text.ParseException;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.PathOptionsTable;
import org.ipea.r5r.R5MultiDestinationProcess;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedItineraryPlanner
extends R5MultiDestinationProcess {
    private static final Logger LOG = LoggerFactory.getLogger(DetailedItineraryPlanner.class);
    private boolean dropItineraryGeometry = false;

    public void dropItineraryGeometry() {
        this.dropItineraryGeometry = true;
    }

    public DetailedItineraryPlanner(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        super(threadPool, transportNetwork, routingProperties);
        routingProperties.timeWindowSize = 1;
        routingProperties.numberOfMonteCarloDraws = 1;
    }

    @Override
    protected void buildDestinationPointSet() {
    }

    @Override
    protected RDataFrame buildDataFrameStructure(String fromId, int nRows) {
        RDataFrame itinerariesDataFrame = new RDataFrame(nRows);
        itinerariesDataFrame.addStringColumn("fromId", fromId);
        itinerariesDataFrame.addDoubleColumn("fromLat", 0.0);
        itinerariesDataFrame.addDoubleColumn("fromLon", 0.0);
        itinerariesDataFrame.addStringColumn("toId", "");
        itinerariesDataFrame.addDoubleColumn("toLat", 0.0);
        itinerariesDataFrame.addDoubleColumn("toLon", 0.0);
        itinerariesDataFrame.addIntegerColumn("option", 0);
        itinerariesDataFrame.addIntegerColumn("segment", 0);
        itinerariesDataFrame.addStringColumn("mode", "");
        itinerariesDataFrame.addDoubleColumn("total_duration", 0.0);
        itinerariesDataFrame.addDoubleColumn("segment_duration", 0.0);
        itinerariesDataFrame.addDoubleColumn("wait", 0.0);
        itinerariesDataFrame.addIntegerColumn("distance", 0);
        itinerariesDataFrame.addStringColumn("route", "");
        if (!this.dropItineraryGeometry) {
            itinerariesDataFrame.addStringColumn("geometry", "");
        }
        return itinerariesDataFrame;
    }

    @Override
    public RDataFrame runProcess(int index) throws ParseException {
        RegionalTask request = this.buildRequest(index);
        ProfileResponse response = this.runQuery(index, request);
        if (response == null) {
            return null;
        }
        if (!response.getOptions().isEmpty()) {
            PathOptionsTable pathOptionsTable = new PathOptionsTable(this.transportNetwork, response);
            pathOptionsTable.setOrigin(this.fromIds[index], this.fromLats[index], this.fromLons[index]);
            pathOptionsTable.setDestination(this.toIds[index], this.toLats[index], this.toLons[index]);
            pathOptionsTable.setTripDuration(this.maxWalkTime, this.maxBikeTime, this.maxTripDuration);
            if (this.dropItineraryGeometry) {
                pathOptionsTable.dropItineraryGeometry();
            }
            pathOptionsTable.build();
            return pathOptionsTable.getDataFrame();
        }
        return null;
    }

    private ProfileResponse runQuery(int index, RegionalTask request) {
        ProfileResponse response;
        PointToPointQuery query = new PointToPointQuery(this.transportNetwork);
        try {
            response = query.getPlan((ProfileRequest)request);
        }
        catch (IllegalStateException e) {
            LOG.error(String.format("Error (*illegal state*) while finding path between %s and %s", this.fromIds[index], this.toIds[index]));
            LOG.error(e.getMessage());
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error(String.format("Error (*array out of bounds*) while finding path between %s and %s", this.fromIds[index], this.toIds[index]));
            LOG.error(e.getMessage());
            return null;
        }
        catch (Exception e) {
            LOG.error(String.format("Error while finding path between %s and %s", this.fromIds[index], this.toIds[index]));
            LOG.error(e.getMessage());
            return null;
        }
        return response;
    }

    @Override
    protected RegionalTask buildRequest(int index) throws ParseException {
        RegionalTask request = super.buildRequest(index);
        request.toLat = this.toLats[index];
        request.toLon = this.toLons[index];
        request.percentiles = new int[1];
        request.percentiles[0] = 50;
        return request;
    }
}

