% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotCohorts.R
\name{SSplotCohorts}
\alias{SSplotCohorts}
\title{Plot cumulative catch by cohort.}
\usage{
SSplotCohorts(replist, subplots = 1:2, add = FALSE, plot = TRUE,
  print = FALSE, cohortcols = "default", cohortfrac = 1,
  cohortvec = NULL, cohortlabfrac = 0.1, cohortlabvec = NULL, lwd = 3,
  plotdir = "default", xlab = "Year", labels = c("Age",
  "Cumulative catch by cohort (in numbers x1000)",
  "Cumulative catch by cohort (x1000 mt)"), pwidth = 6.5, pheight = 5,
  punits = "in", res = 300, ptsize = 10, cex.main = 1, verbose = TRUE)
}
\arguments{
\item{replist}{List created by \code{SS_output}}

\item{subplots}{Vector controlling which subplots to create}

\item{add}{Add to existing plot? (not yet implemented)}

\item{plot}{Plot to active plot device?}

\item{print}{Print to PNG files?}

\item{cohortcols}{Vector of colors to show for each cohort. Default is range
of colors shade indicating time period.}

\item{cohortfrac}{What fraction of the cohorts to include in plot. If value
< 1 is used, then cohorts are filtered to only include those with the
highest maximum cumulative catch. Value will be overridden by
\code{cohortvec}.}

\item{cohortvec}{Optional vector of birth years for cohorts to include in
plot. Value overrides \code{cohortfrac}.}

\item{cohortlabfrac}{What fraction of the cohorts to label in plot. By
default, top 10\% of cohorts are labeled. Value will be overridden by
\code{cohortlabvec}.}

\item{cohortlabvec}{Optional vector of birth years for cohorts to label in
plot. Value overrides \code{cohortlabfrac}.}

\item{lwd}{Line width}

\item{plotdir}{Directory where PNG or PDF files will be written. By default
it will be the directory where the model was run.}

\item{xlab}{x-label for all plots}

\item{labels}{Vector of labels for plots (titles and axis labels)}

\item{pwidth}{Width of plot}

\item{pheight}{Height of plot}

\item{punits}{Units for PNG file}

\item{res}{Resolution for PNG file}

\item{ptsize}{point size for PNG file}

\item{cex.main}{Character expansion for plot titles (no titles in this
function yet)}

\item{verbose}{Report progress to R console?}
}
\description{
Cumulative catch contributions for each cohort are plotted based on
estimated catch-at-age matrix and weight-at-age values by fleet.  Curves are
shown in units of both numbers and biomass.
}
\author{
Ian Taylor
}
\seealso{
\code{\link{SS_plots}}, \code{\link{SS_output}}
}
\keyword{aplot}
\keyword{hplot}

