% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{regression}
\alias{regression}
\alias{print.regressionSPSS}
\alias{coef.regressionSPSS}
\alias{df.residual.regressionSPSS}
\alias{fitted.regressionSPSS}
\alias{residuals.regressionSPSS}
\alias{plot.regressionSPSS}
\title{Linear Regression}
\usage{
regression(..., data, labels = NULL, change = FALSE)

\method{print}{regressionSPSS}(x, digits = 3, statistics = c("summary", "anova", "estimates"), ...)

\method{coef}{regressionSPSS}(object, ...)

\method{df.residual}{regressionSPSS}(object, ...)

\method{fitted}{regressionSPSS}(object, standardized = FALSE, ...)

\method{residuals}{regressionSPSS}(object, standardized = FALSE, ...)

\method{plot}{regressionSPSS}(
  x,
  y,
  which = c("histogram", "scatter"),
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{\dots}{for \code{regression}, at least one formula specifying a
regression model.  Different models can be compared by supplying multiple
formulas.  For the \code{plot} method, additional arguments to be passed
down, in particular graphical parameters (see also \code{\link{histSPSS}}
and \code{\link{plotSPSS}}).  For other methods, this is currently ignored.}

\item{data}{a data frame containing the variables.}

\item{labels}{a character or numeric vector giving labels for the
regression models in the output tables.}

\item{change}{a logical indicating whether tests on the
\eqn{R^2}{R-squared} change should be included in model summaries.}

\item{x, object}{an object of class \code{"regressionSPSS"} as returned by
function \code{regression}.}

\item{digits}{an integer giving the number of digits after the comma to be
printed in the LaTeX tables.}

\item{statistics}{a character vector specifying which LaTeX tables should
be printed.  Available options are \code{"summary"} for model summaries,
\code{"anova"} for ANOVA results, and \code{"estimates"} for estimated
coefficients.  The default is to print all tables.}

\item{standardized}{a logical indicating whether to return standardized
residuals and fitted values (\code{TRUE}), or residuals and fitted values on
their original scale (\code{FALSE}).}

\item{y}{ignored (only included because it is defined for the generic
function \code{\link[graphics]{plot}}).}

\item{which}{a character string specifying which plot to produce.  Possible
values are \code{"histogram"} for a histogram of the residuals, or
\code{"scatter"} for a scatterplot of the standardized residuals against the
standardized fitted values.}

\item{main, xlab, ylab}{the plot title and axis labels.}
}
\value{
An object of class \code{"regressionSPSS"} with the following
components:
\describe{
  \item{\code{models}}{a list in which each component is an ojbect of class
  \code{"lm"} as returned by function \code{\link[stats]{lm}}.}
  \item{\code{response}}{a character string containing the name of the
  response variable.}
  \item{\code{method}}{a character string specifying whether the nested
  models are increasing in dimension by entering additional variables
  (\code{"enter"}) or decreasing in dimension by removing variables
  (\code{"remove"}).}
  \item{\code{change}}{a logical indicating whether tests on the
  \eqn{R^2}{R-squared} change are included in model summaries.}
}

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output (version <24).

The \code{coef}, \code{df.residual}, \code{fitted} and \code{residuals}
methods return the coefficients, residual degrees of freedom, fitted
values and residuals, respectively, of the \emph{last} model (to mimic
SPSS functionality).

Similarly, the \code{plot} method creates the specified plot for the
\emph{last} model.
}
\description{
Perform linear regression on variables of a data set.  The output is printed
as a LaTeX table that mimics the look of SPSS output (version <24), and plots
of the results mimic the look of SPSS graphs.
}
\examples{
# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)
# squared values of age
Eredivisie$AgeSq <- Eredivisie$Age^2

# simple regression model of log market value on age
fit1 <- regression(logMarketValue ~ Age, data = Eredivisie)
fit1                           # print LaTeX table
plot(fit1, which = "scatter")  # diagnostic plot

# add a squared effect for age
fit2 <- regression(logMarketValue ~ Age + AgeSq,
                   data = Eredivisie, labels = 2)
fit2                           # print LaTeX table
plot(fit2, which = "scatter")  # diagnostic plot

# more complex models with model comparison
fit3 <- regression(logMarketValue ~ Age + AgeSq,
                   logMarketValue ~ Age + AgeSq + Contract +
                                    Foreign,
                   logMarketValue ~ Age + AgeSq + Contract +
                                    Foreign + Position,
                   data = Eredivisie, labels = 2:4,
                   change = TRUE)
fit3                             # print LaTeX table
plot(fit3, which = "histogram")  # diagnostic plot

}
\author{
Andreas Alfons
}
\keyword{multivariate}
