/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Model;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.rexp.Formula;
import org.jpmml.rexp.FormulaContext;
import org.jpmml.rexp.FormulaUtil;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.ModelFrameFormulaContext;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;

public class LMConverter
extends ModelConverter<RGenericVector> {
    private Formula formula = null;
    public static final String INTERCEPT = "(Intercept)";

    public LMConverter(RGenericVector lm) {
        super(lm);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector lm = (RGenericVector)this.getObject();
        final RGenericVector xlevels = lm.getGenericElement("xlevels", false);
        RGenericVector model = lm.getGenericElement("model");
        final RGenericVector data = lm.getGenericElement("data", false);
        RExp terms = model.getAttribute("terms");
        ModelFrameFormulaContext context = new ModelFrameFormulaContext(model){

            @Override
            public List<String> getCategories(String variable) {
                if (xlevels != null && xlevels.hasElement(variable)) {
                    RStringVector levels = xlevels.getStringElement(variable);
                    return levels.getValues();
                }
                return super.getCategories(variable);
            }

            @Override
            public RVector<?> getData(String variable) {
                if (data != null && data.hasElement(variable)) {
                    return data.getVectorElement(variable);
                }
                return super.getData(variable);
            }
        };
        this.encodeSchema(terms, context, encoder);
    }

    protected void encodeSchema(RExp terms, FormulaContext context, RExpEncoder encoder) {
        Formula formula = FormulaUtil.createFormula(terms, context, encoder);
        FormulaUtil.setLabel(formula, terms, null, encoder);
        List<String> names = FormulaUtil.removeSpecialSymbol(this.getCoefficientNames(), this.getInterceptName());
        FormulaUtil.addFeatures(formula, names, true, encoder);
        this.formula = formula;
    }

    @Override
    public Model encodeModel(Schema schema) {
        RGenericVector lm = (RGenericVector)this.getObject();
        RDoubleVector coefficients = lm.getDoubleElement("coefficients");
        Double intercept = (Double)coefficients.getElement(this.getInterceptName(), false);
        List features = schema.getFeatures();
        SchemaUtil.checkSize((int)(coefficients.size() - (intercept != null ? 1 : 0)), (List)features);
        List<Double> featureCoefficients = this.getFeatureCoefficients(features, coefficients);
        return RegressionModelUtil.createRegression((List)features, featureCoefficients, (Double)intercept, null, (Schema)schema);
    }

    public String getInterceptName() {
        return INTERCEPT;
    }

    public List<String> getCoefficientNames() {
        RGenericVector lm = (RGenericVector)this.getObject();
        RDoubleVector coefficients = lm.getDoubleElement("coefficients");
        RStringVector coefficientNames = coefficients.names();
        return coefficientNames.getDequotedValues();
    }

    public List<Double> getFeatureCoefficients(List<? extends Feature> features, RDoubleVector coefficients) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (Feature feature : features) {
            Double coefficient = this.getFeatureCoefficient(feature, coefficients);
            result.add(coefficient);
        }
        return result;
    }

    public Double getFeatureCoefficient(Feature feature, RDoubleVector coefficients) {
        return this.formula.getCoefficient(feature, coefficients);
    }
}

