/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.BranchNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.SimpleNode;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.AbstractTransformation;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FortranMatrixUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.TreeModelConverter;

public class IForestConverter
extends TreeModelConverter<RGenericVector> {
    public IForestConverter(RGenericVector iForest) {
        super(iForest);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector iForest = (RGenericVector)this.getObject();
        RStringVector xcols = iForest.getStringElement("xcols");
        RBooleanVector colisfactor = iForest.getBooleanElement("colisfactor");
        if (xcols.size() != colisfactor.size()) {
            throw new IllegalArgumentException();
        }
        boolean hasFactors = false;
        for (int i = 0; i < colisfactor.size(); ++i) {
            hasFactors |= colisfactor.getValue(i).booleanValue();
        }
        if (hasFactors) {
            throw new IllegalArgumentException();
        }
        DataField dataField = encoder.createDataField(FieldName.create((String)"pathLength"), OpType.CONTINUOUS, DataType.DOUBLE);
        encoder.setLabel(dataField);
        for (int i = 0; i < xcols.size(); ++i) {
            String xcol = xcols.getValue(i);
            DataField dataField2 = encoder.createDataField(FieldName.create((String)xcol), OpType.CONTINUOUS, DataType.DOUBLE);
            encoder.addFeature((Field<?>)dataField2);
        }
    }

    @Override
    public Model encodeModel(Schema schema) {
        RGenericVector iForest = (RGenericVector)this.getObject();
        RGenericVector trees = iForest.getGenericElement("trees");
        RDoubleVector ntree = iForest.getDoubleElement("ntree");
        if (trees == null) {
            throw new IllegalArgumentException();
        }
        final RIntegerVector xrow = trees.getIntegerElement("xrow");
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (int i = 0; i < ValueUtil.asInt((Number)((Number)ntree.asScalar())); ++i) {
            TreeModel treeModel = this.encodeTreeModel(trees, i, segmentSchema);
            treeModels.add(treeModel);
        }
        AbstractTransformation normalizedPathLength = new AbstractTransformation(){

            public FieldName getName(FieldName name) {
                return FieldName.create((String)"normalizedPathLength");
            }

            public Expression createExpression(FieldRef fieldRef) {
                return PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{fieldRef, PMMLUtil.createConstant((Number)IForestConverter.avgPathLength(((Integer)xrow.asScalar()).intValue()))});
            }
        };
        AbstractTransformation anomalyScore = new AbstractTransformation(){

            public FieldName getName(FieldName name) {
                return FieldName.create((String)"anomalyScore");
            }

            public boolean isFinalResult() {
                return true;
            }

            public Expression createExpression(FieldRef fieldRef) {
                return PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)2.0), PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)-1.0), fieldRef})});
            }
        };
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel())).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.AVERAGE, treeModels)).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)"rawPathLength"), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{normalizedPathLength, anomalyScore}));
        return miningModel;
    }

    private TreeModel encodeTreeModel(RGenericVector trees, int index, Schema schema) {
        RIntegerVector nrnodes = trees.getIntegerElement("nrnodes");
        RIntegerVector ntree = trees.getIntegerElement("ntree");
        RIntegerVector nodeStatus = trees.getIntegerElement("nodeStatus");
        RIntegerVector leftDaughter = trees.getIntegerElement("lDaughter");
        RIntegerVector rightDaughter = trees.getIntegerElement("rDaughter");
        RIntegerVector splitAtt = trees.getIntegerElement("splitAtt");
        RDoubleVector splitPoint = trees.getDoubleElement("splitPoint");
        RIntegerVector nSam = trees.getIntegerElement("nSam");
        int rows = (Integer)nrnodes.asScalar();
        int columns = (Integer)ntree.asScalar();
        Node root = this.encodeNode((Predicate)new True(), 0, 0, FortranMatrixUtil.getColumn(nodeStatus.getValues(), (int)rows, (int)columns, (int)index), FortranMatrixUtil.getColumn(nSam.getValues(), (int)rows, (int)columns, (int)index), FortranMatrixUtil.getColumn(leftDaughter.getValues(), (int)rows, (int)columns, (int)index), FortranMatrixUtil.getColumn(rightDaughter.getValues(), (int)rows, (int)columns, (int)index), FortranMatrixUtil.getColumn(splitAtt.getValues(), (int)rows, (int)columns, (int)index), FortranMatrixUtil.getColumn(splitPoint.getValues(), (int)rows, (int)columns, (int)index), schema);
        TreeModel treeModel = new TreeModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel()), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT);
        return treeModel;
    }

    private Node encodeNode(Predicate predicate, int index, int depth, List<Integer> nodeStatus, List<Integer> nodeSize, List<Integer> leftDaughter, List<Integer> rightDaughter, List<Integer> splitAtt, List<Double> splitValue, Schema schema) {
        int status = nodeStatus.get(index);
        int size = nodeSize.get(index);
        Integer id = index + 1;
        if (status == -3) {
            int att = splitAtt.get(index);
            ContinuousFeature feature = (ContinuousFeature)schema.getFeature(att - 1);
            Double value = splitValue.get(index);
            Predicate leftPredicate = this.createSimplePredicate((Feature)feature, SimplePredicate.Operator.LESS_THAN, value);
            Predicate rightPredicate = this.createSimplePredicate((Feature)feature, SimplePredicate.Operator.GREATER_OR_EQUAL, value);
            Node leftChild = this.encodeNode(leftPredicate, leftDaughter.get(index) - 1, depth + 1, nodeStatus, nodeSize, leftDaughter, rightDaughter, splitAtt, splitValue, schema);
            Node rightChild = this.encodeNode(rightPredicate, rightDaughter.get(index) - 1, depth + 1, nodeStatus, nodeSize, leftDaughter, rightDaughter, splitAtt, splitValue, schema);
            Node result = new BranchNode().setId((Object)id).setPredicate(predicate).addNodes(new Node[]{leftChild, rightChild});
            return result;
        }
        if (status == -1) {
            SimpleNode result = new LeafNode().setId((Object)id).setScore((Object)((double)depth + IForestConverter.avgPathLength(size))).setPredicate(predicate);
            return result;
        }
        throw new IllegalArgumentException();
    }

    private static double avgPathLength(double n) {
        double j = n - 1.0;
        if (j <= 0.0) {
            return 0.0;
        }
        return 2.0 * (Math.log(j) + 0.5772156649) - 2.0 * (j / n);
    }
}

