\name{r2lUniv.r2lBasicClasses}
\alias{r2lUniv.r2lBasicClasses}
\alias{r2lUniv.nominal}
\alias{r2lUniv.ordinal}
\alias{r2lUniv.discrete}
\alias{r2lUniv.continuous}

\title{Methods for r2l basic classes}
\description{
  Method used by \code{r2lUniv} for \link[=r2lConcepts]{r2lUniv basic classes}.
  
  On \link[=r2lConcepts]{r2lUniv basic classes}, \code{r2lUniv} makes some
  analyses according to the variable class, then exports the LaTeX
  code.
}
\usage{
\method{r2lUniv}{nominal}(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V",...)
\method{r2lUniv}{ordinal}(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V",...)
\method{r2lUniv}{discrete}(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V",...)
\method{r2lUniv}{continuous}(data, fileOutput = "", varName = NA, varNumber = NA, dirGraph = "", graphName = "V",...)
}
%- maybe also 'usage' for other objects documented here.


\arguments{
  \item{data}{\code{vector};
    to print}
  
  \item{fileOutput}{\code{character};
    name of the output file to save the LaTeX code. If
    empty, code is printed on screen.}
  
  \item{varName}{\code{character}, single;
    title of the \link[=r2lConcepts]{LaTeX summary}. For no title, use NA
    instead of "".}
  
  \item{varNumber}{\code{numeric}, single;
    number to be printed before the title. For no number, use NA
    instead of "".}
  
  \item{dirGraph}{\code{character};
    Directory used to save the graphs generated by the analyses.}
  
  \item{graphName}{\code{character}, single;
    Prefix of the graphs' names. The full names of the graphs will be
    \code{graphName} with a postfix in ("-boxplot.eps", "-barplot.eps",
    "-hist.eps") }

  \item{...}{For S3 compatibility only}
}

\details{
  On \link[=r2lConcepts]{r2lUniv basic classes}, \code{r2lUniv} makes some
  analyses according to the variable class, then exports the LaTeX
  code.

  The analyses depend on the \link[=r2lConcepts]{r2lUniv basic classes}:
  \enumerate{
    \item \emph{Nominal}: Frequency. Graph: barplot.
    \item \emph{Ordinal}: Frequency and quartile. Graph: barplot.
    \item \emph{Discrete}: Frequency, mean, variance, quartile. Graph: boxplot and barplot.
    \item \emph{Continuous}: Mean, variance, quartile. Graph: boxplot and
    histogram.
  }

  Then the \link[=r2lConcepts]{LaTeX summary} is exported, either on the
  screen, or in a file specified by \code{fileOutput}.
}

\value{
  \code{r2lUniv} either prints LaTeX code on the screen or saves it in a
  file. It also generates several \emph{encapsuled postsript} graphs (.eps), optionally
  in a directory.\cr
}
\section{R to LaTeX, Bivariate Analyses}{
  \emph{r2lBiv} (R to LaTeX, Bivariate Analyses) is under contruction. Any
  help will be welcomed!
}

\section{Author}{
  Christophe Genolini \cr
  \email{christophe.genolini@free.fr}\cr
  PSIGIAM: Paris Sud Innovation Group in Adolescent Mental Health \cr
  INSERM U669 / Maison de Solenn / Paris
}

\section{English correction}{
  Jean-Marc Chamot \cr
  \email{jchamot@u-paris10.fr}\cr
  Laboratoire "Sport & Culture" / "Sports & Culture" Laboratory \cr
  University of Paris 10 / Nanterre
}


\references{LaTeX web site \url{http://www.latex-project.org/}}


\seealso{\code{\link[utils]{Sweave}},
  \code{\link[Hmisc]{latex}},
  \code{\link{r2lConcepts}},
  \code{\link{r2lUniv.data.frame}},
  \code{\link{r2lUniv.r2lBasicClasses}},
  \code{\link{r2lUniv.Rclasses}}
}

\examples{
 # # # # # # # # # # # # # # # # # # #
#   R to LaTeX, Univariate Analyses   #
 #             Examples              #
  #        r2l Basic classes        #
   # # # # # # # # # # # # # # # # #

########################
###### Step 1: Load the data

data(Vnominal)
data(Vordinal)
data(Vdiscrete)
data(Vcontinuous)


########################
###### Step 4: Run

### The following code will create some files.
### We advise you to first move in directory "r2lUnivExample"
dir.create("r2lUnivExample")
setwd("r2lUnivExample")
dir.create("graph")

r2lUniv(Vnominal,"nominal.tex")
r2lUniv(Vordinal,"ordinal.tex",varName="Peep",graphName="O")
r2lUniv(Vdiscrete,"discrete.tex",varNumber="3",graphName="D",dirGraph="graph")
r2lUniv(Vcontinuous,"continuous.tex",varName="CheatScore",varNumber="4",graphName="C")

### Creates the main document.
r2lGenerateLatexMain(c("nominal.tex","ordinal.tex","discrete.tex","continuous.tex"))

### Everything is ready, you can now run LaTeX on the file "main.tex"
setwd("..")
}


\keyword{univar}       % Simple univariate statistics
\keyword{interface}    % interface to other languages
\keyword{utilities}    % Utilities
\keyword{classes}      % Data type
\keyword{print}        % Printing



