% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_r2dii_tech.R
\name{scale_colour_r2dii_tech}
\alias{scale_colour_r2dii_tech}
\alias{scale_color_r2dii_tech}
\alias{scale_fill_r2dii_tech}
\title{Custom 2DII technology colour and fill scales}
\usage{
scale_colour_r2dii_tech(sector, technologies = NULL, ...)

scale_fill_r2dii_tech(sector, technologies = NULL, ...)
}
\arguments{
\item{sector}{A string. Sector name specifying a colour palette. Run
\code{unique(r2dii.plot:::technology_colours$sector)} to see available sectors.}

\item{technologies}{A character vector. Specifies technologies to use as
colours and their order. Run
\code{unique(r2dii.plot:::technology_colours$technology)} to see available
technologies (pay attention if they match the \code{sector}). Similar to \code{value}
parameter in \code{\link[ggplot2:scale_manual]{ggplot2::scale_colour_manual()}}.}

\item{...}{Other parameters passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\value{
An object of class "ScaleDiscrete".
}
\description{
A custom discrete colour and fill scales with colours from 2DII technology
palette.
}
\examples{
library(ggplot2, warn.conflicts = FALSE)

ggplot(mpg) +
  geom_point(aes(displ, hwy, color = class)) +
  scale_colour_r2dii_tech("automotive")

ggplot(mpg) +
  geom_histogram(aes(cyl, fill = class), position = "dodge", bins = 5) +
  scale_fill_r2dii_tech("automotive")
}
\seealso{
Other r2dii scales: 
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii}()}
}
\concept{r2dii scales}
