% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame_ald_weight.R
\name{frame_ald_weight}
\alias{frame_ald_weight}
\title{Weighting Matrix of Quantile regression using
Asymmetric Laplace Distrubtion}
\usage{
frame_ald_weight(y, x, tau, error, iter)
}
\arguments{
\item{y}{dependent variable of quantile regression}

\item{x}{design matrix of quantile regression}

\item{tau}{quantile must be a scaler}

\item{error}{The EM algorithm accuracy of error used in MLE estimation}

\item{iter}{The iteration frequancy for EM algorithm used in MLE estimation}
}
\description{
This function calulate the weighting matrix
}
\details{
In the estimation procedure in EM algorithm, we can see that
\eqn{\varepsilon} is inversely proportional to
\eqn{d_i = |y_i-x^{'}_{i}\beta^{(k)}_{p}|/\sigma}.
Hence, \eqn{u_i(\theta^{k})=\varepsilon_{-1i}(\theta^{(k)})}
can be interpreted as a type of weight for \eqn{i}th case in the estimates of
\eqn{\beta_{(k)^p}}, which tends to be small for outlying observations.
}
\examples{
library(ggplot2)
library(dplyr)
library(ALDqr)
data(ais)
y <- ais$BMI
x <- cbind(1, ais$LBM)
tau <-  c(0.1, 0.5, 0.9)
error <- 1e-06
iter <- 100
weights <- frame_ald_weight(y, x, tau, error, iter)
weights

}
\author{
Wenjing Wang \email{wenjingwangr@gmail.com}
}
