% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{subset-traits}
\alias{subset-traits}
\alias{[,traits,missing,missing,missing-method}
\alias{[,traits,numeric,missing,missing-method}
\alias{[,traits,character,missing,missing-method}
\title{Subset a traits object}
\usage{
\S4method{[}{traits,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{traits,numeric,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{traits,character,missing,missing}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \linkS4class{traits} object.}

\item{i}{Position of the identifier or the name of the identifier itself.}

\item{j}{Not used.}

\item{...}{Additional arguments not used here.}

\item{drop}{Not used.}
}
\value{
A \linkS4class{traits} object.
}
\description{
You can subset \linkS4class{traits} by identifier or by position using the
\code{`[`} operator.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get a few traits:
my_traits <- get_traits(trait_term = 'stroke', exact_term = FALSE,
               progress_bar = FALSE)

#
# Subsetting by position
#
my_traits[1]

#
# Subsetting by EFO trait identifier (character)
#
my_traits['EFO_0000712']
\dontshow{\}) # examplesIf}
}
\keyword{internal}
