% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parbootstrap.R
\name{parbootstrap}
\alias{parbootstrap}
\title{Creates bootstrap samples of the parameters}
\usage{
parbootstrap(qp, bootstrap = "parametric", B = 10)
}
\arguments{
\item{qp}{output from quickpsy}

\item{bootstrap}{\code{'parametric'} performs parametric bootstrap;
\code{'nonparametric'} performs non-parametric bootstrap;
\code{'none'} does not perform bootstrap (default is \code{'parametric'}).}

\item{B}{number of bootstrap samples (default is 100 ONLY).}
}
\description{
\code{parbootstrap} creates bootstrap samples of the parameters.
}
\examples{
library(MPDiR) # contains the Vernier data
data(Vernier) # ?Venier for the reference
fit <- quickpsy(Vernier, Phaseshift, NumUpward, N,
                grouping = .(Direction, WaveForm, TempFreq),
                bootstrap = 'none')
boot_samples <- parbootstrap(fit)
head(boot_samples)
}

