% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_pop.R
\name{vector_pop}
\alias{vector_pop}
\title{Remove last n elements or specified elements from a vector like array_pop in PHP}
\usage{
vector_pop(., n = 1, el = NULL, ret = FALSE)
}
\arguments{
\item{.}{parent vector}

\item{n}{number of elements to remove}

\item{el}{vector to remove}

\item{ret}{TRUE or FALSE. whether to return value instead of setting it to the parent vector}
}
\value{
vector with elements removed
}
\description{
Shorthand to remove elements from a vector and save as the same name
}
\examples{
num1 <- sample(330:400,10)
name1 <- "ObinnaObianomObiObianom"

#task: remove 1 element from the end of the vector and set it to the vector name
num1 #num1 vector before pop
vector_pop(num1) #does not return anything
num1 #num1 vector updated after pop

#task: remove 5 elements from the end, but do not set it to the vector name
num1 #num1 vector before pop
vector_pop(num1,5, ret = TRUE) #return modified vector
num1 #num1 vector remains the same after pop


#task: remove 6 elements from a word, set it back to vector name
name1 #name1 before pop
vector_pop(name1,6) #does not return anything
name1 #name updated after pop

#task: remove 3 elements from a word, Do not set it back to vector name
name1 #name1 before pop
vector_pop(name1,3, ret = TRUE) #returns modified name1
name1 #name1 not updated after pop


}
