% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{flat_list_of}
\alias{flat_list_of}
\title{Variable length flat list generator}
\usage{
flat_list_of(generator, len = c(1L, 10L))
}
\arguments{
\item{generator}{A \code{quickcheck_generator} object.}

\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10. To produce empty vectors
set \code{len = 0L} or a range like \code{len = c(0L, 10L)}.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
Generate flat lists with all values coming from a single generator. In a flat
list all items will be scalars.
}
\examples{
flat_list_of(integer_(), len = 10L) |> show_example()
}
