% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical.R
\name{logical_}
\alias{logical_}
\title{Logical generator}
\usage{
logical_(len = 1L, frac_na = 0)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10.}

\item{frac_na}{The approximate fraction of \code{NA} values to
be included in the vector. A fraction of 0, the default,
will include no \code{NA} values. A fraction of 0.5 would
include around 50\% \code{NA} values.}
}
\value{
A \code{hedgehog.internal.gen} generator
}
\description{
A generator for logical vectors.
}
\examples{
logical_() |> show_example()
logical_(len = 10L, frac_na = 0.5) |> show_example()
}
