% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\docType{methods}
\name{.plotGrob}
\alias{.plotGrob}
\alias{.plotGrob,SpatialPoints-method}
\alias{.plotGrob,matrix-method}
\alias{.plotGrob,SpatialPolygons-method}
\alias{.plotGrob,SpatialLines-method}
\title{Plot spatial grobs (using \pkg{grid} package)}
\usage{
.plotGrob(grobToPlot, col = NULL, real = FALSE, size = unit(5, "points"),
  minv, maxv, legend = TRUE, legendText = NULL, length = NULL,
  gp = gpar(), gpText = gpar(), pch = 19, speedup = 1,
  name = character(), vp = list(), ...)

\S4method{.plotGrob}{SpatialPoints}(grobToPlot, col = NULL, real = FALSE,
  size = unit(5, "points"), minv, maxv, legend = TRUE, legendText = NULL,
  length = NULL, gp = gpar(), gpText = gpar(), pch = 19, speedup = 1,
  name = character(), vp = list(), ...)

\S4method{.plotGrob}{matrix}(grobToPlot, col = NULL, real = FALSE,
  size = unit(5, "points"), minv, maxv, legend = TRUE, legendText = NULL,
  length = NULL, gp = gpar(), gpText = gpar(), pch = 19, speedup = 1,
  name = character(), vp = list(), ...)

\S4method{.plotGrob}{SpatialPolygons}(grobToPlot, col = NULL, real = FALSE,
  size = unit(5, "points"), minv, maxv, legend = TRUE, legendText = NULL,
  length = NULL, gp = gpar(), gpText = gpar(), pch = 19, speedup = 1,
  name = character(), vp = list(), ...)

\S4method{.plotGrob}{SpatialLines}(grobToPlot, col = NULL, real = FALSE,
  size = unit(5, "points"), minv, maxv, legend = TRUE, legendText = NULL,
  length = NULL, gp = gpar(), gpText = gpar(), pch = 19, speedup = 1,
  name = character(), vp = list(), ...)
}
\arguments{
\item{grobToPlot}{\code{Raster*}, \code{SpatialLines*},
\code{SpatialPoints*}, or \code{SpatialPolygons*} object.}

\item{col}{Currently only used for the legend of a \code{Raster*} object.}

\item{real}{Logical indicating whether the data are \code{real} numbers
(i.e., as opposed to \code{integer} or \code{factor}).}

\item{size}{The size of the \code{SpatialPoints}.}

\item{minv}{The minimum value on a \code{Raster*}. Required because not
all Rasters have this defined internally.}

\item{maxv}{The maximum value on a \code{Raster*}. Required because not
all Rasters have this defined internally.}

\item{legend}{Logical indicating whether a legend should be drawn.
Default \code{TRUE}.}

\item{legendText}{Vector of values to use for legend value labels.
Defaults to \code{NULL} which results in a pretty numeric
representation. If \code{Raster*} has a Raster Attribute
Table (rat; see \pkg{raster} package), this will be used
by default. Currently, only a single vector is accepted.}

\item{length}{Numeric.}

\item{gp}{\code{grid} parameters, usually the output of a call to
\code{\link{gpar}}.}

\item{gpText}{\code{gpar} object for legend label text.}

\item{pch}{Point character for \code{SpatialPoints}, as \code{par}.}

\item{speedup}{Numeric. The factor by which the number of vertices in
\code{SpatialPolygons} and \code{SpatialLines*} will be
subsampled. The vertices are already subsampled by default to
make plotting faster.}

\item{name}{Character string of name of object being plotted.}

\item{vp}{whole viewport tree of \code{quickPlotGrob}}

\item{...}{Additional arguments. None currently implemented.}
}
\description{
Internal function. Plot a raster Grob, a points Grob, polygon Grob.
}
\details{
\code{speedup} is only used for \code{SpatialPolygons}, \code{SpatialPoints},
and \code{SpatialLines} in this function.
Attempts have been made to subsample at a good level that optimizes speed of
plotting, without losing visible quality. Nevertheless, to force all points to
be plotted, use a speedup value less than 0.1.
From a speed perspective, there appears to be an optimal subsampling when
using \code{thin} from the \pkg{fastshp} package.
Presumably, too much thinning requires large distance matrices to be
calculated, slowing plotting down.
Too little thinning causes an overabundance of points to be plotted, slowing
plotting down.

The suggested package \code{fastshp} can be installed with:
\code{install.packages("fastshp", repos = "https://rforge.net", type = "source")}.

NOTE: you may get errors relating to not having installed the software tools
required for building R packages on your system.
For building on Windows, you'll need to install \code{Rtools} from
\url{https://cran.r-project.org/bin/windows/Rtools/}.
}
\author{
Eliot McIntire
}
\keyword{internal}
