% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\docType{methods}
\name{.preparePlotGrob}
\alias{.preparePlotGrob}
\alias{PlotHelpers}
\alias{.preparePlotGrob,griddedClasses,.quickPlotGrob-method}
\alias{PlotHelpers}
\alias{.xyAxes}
\alias{PlotHelpers}
\alias{.xyAxes,.quickPlotGrob,.arrangement-method}
\alias{PlotHelpers}
\alias{.Plot}
\alias{PlotHelpers}
\alias{.Plot,.quickPlotGrob-method}
\alias{PlotHelpers}
\alias{.refreshGrob}
\alias{PlotHelpers}
\alias{.refreshGrob,.quickPlotGrob-method}
\alias{PlotHelpers}
\alias{.updateGrobGPTextAxis}
\alias{PlotHelpers}
\alias{.updateGrobGPTextAxis,.quickPlotGrob-method}
\alias{PlotHelpers}
\title{Internal functions used by Plot}
\usage{
.preparePlotGrob(grobToPlot, sGrob, takeFromPlotObj, arr, newArr,
  quickPlotGrobCounter, subPlots, cols)

\S4method{.preparePlotGrob}{griddedClasses,.quickPlotGrob}(grobToPlot, sGrob,
  takeFromPlotObj, arr, newArr, quickPlotGrobCounter, subPlots, cols)

.xyAxes(sGrob, arr, whPlotFrame)

\S4method{.xyAxes}{.quickPlotGrob,.arrangement}(sGrob, arr, whPlotFrame)

.Plot(sGrob, grobToPlot, subPlots, quickSubPlots, quickPlotGrobCounter,
  isBaseSubPlot, isNewPlot, isReplot, zMat, wipe, xyAxes, legendText, vps,
  nonPlotArgs)

\S4method{.Plot}{.quickPlotGrob}(sGrob, grobToPlot, subPlots, quickSubPlots,
  quickPlotGrobCounter, isBaseSubPlot, isNewPlot, isReplot, zMat, wipe, xyAxes,
  legendText, vps, nonPlotArgs)

.refreshGrob(sGrob, subPlots, legendRange, grobToPlot, plotArgs, nColumns,
  nRows, whPlotObj)

\S4method{.refreshGrob}{.quickPlotGrob}(sGrob, subPlots, legendRange,
  grobToPlot, plotArgs, nColumns, nRows, whPlotObj)

.updateGrobGPTextAxis(sGrob, arr, newArr)

\S4method{.updateGrobGPTextAxis}{.quickPlotGrob}(sGrob, arr, newArr)
}
\arguments{
\item{grobToPlot}{Graphical object to plot}

\item{sGrob}{quickPlotGrob object}

\item{takeFromPlotObj}{Logical indicating whether data for grobToPlot should be found in
current call to Plot or from disk}

\item{arr}{An arrangement object}

\item{newArr}{Logical, whether there is a new arrangement happening}

\item{quickPlotGrobCounter}{Numeric. A counter. No meaning outside Plot function.}

\item{subPlots}{Character. Name of plot area.}

\item{cols}{Color vector.}

\item{whPlotFrame}{Numeric. Which plot within the quickPlotGrobPlots object.}

\item{quickSubPlots}{List of many quickPlotGrobs}

\item{isBaseSubPlot}{Logical. Is the currently being plotted object a base layer}

\item{isNewPlot}{Logical. Is the currently being plotted object a new, additional plot}

\item{isReplot}{Logical. Is the currently being plotted object a replot due to something
like a rearrangement}

\item{zMat}{List resulting from \code{.preparePlotGrob}}

\item{wipe}{Logical. Is the currently being plotted object require a white rectangle to
be plotted first, and subsequent other changes.}

\item{xyAxes}{List of length 2, resulting from \code{.xyAxes}}

\item{legendText}{Character vector of legend value labels.
Defaults to \code{NULL}, which results in a pretty numeric
representation.
If \code{Raster*} has a Raster Attribute Table (\code{rat};
see \pkg{raster} package), this will be used by default.
Currently, only a single vector is accepted.
The length of this must match the length of the legend, so
this is mostly useful for discrete-valued rasters.}

\item{vps}{A viewport tree resulting from \code{.makeViewports}}

\item{nonPlotArgs}{Arguments passed to \code{Plot} that are not \code{.quickPlottables},
but are passed along with \code{.quickPlottables}.}

\item{legendRange}{Numeric vector giving values that, representing the lower
and upper bounds of a legend (i.e., \code{1:10} or
\code{c(1,10)} will give same result) that will override
the data bounds contained within the \code{grobToPlot}.}

\item{plotArgs}{list. Any arguments that the the grid package can accept for
the specific grob types, e.g., rasterGrob, polygonGrob, etc.}

\item{nColumns}{Numeric, length 1, indicating how many columns are in the device arrangement}

\item{nRows}{Numeric, length 1, indicating how many rows are in the device arrangement}

\item{whPlotObj}{Numeric. Length 1, indicating which of the currently objects passed into
\code{Plot} is currently being plotted, i.e., a counter of sorts.}
}
\description{
Extract colors, legends and other things from object, and convert to a plotGrob
}
\author{
Eliot McIntire
}
\keyword{internal}
