% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{aggs}
\alias{aggs}
\title{Aggregate Data by Group}
\usage{
aggs(
  data,
  vrb.nm,
  grp.nm,
  rep = TRUE,
  rtn.grp = !rep,
  sep = "_",
  suffix = "_a",
  fun,
  ...
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
groups.}

\item{rep}{logical vector of length 1 specifying whether the result of
\code{fun} should be repeated for every instance of the group in
\code{data[vrb.nm]} (TRUE) or only once for each group (FALSE).}

\item{rtn.grp}{logical vector of length 1 specifying whether the group
columns (i.e., \code{data[grp.nm]}) should be included in the return object
as columns. The default is the opposite of \code{rep} as traditionally it
is most important to return the group columns when \code{rep} = FALSE.}

\item{sep}{character vector of length 1 specifying what string should
separate different group values when naming the return object. This
argument is only used if \code{grp.nm} has length > 1 AND \code{rep} =
FALSE AND \code{rtn.grp} = FALSE.}

\item{suffix}{character vector of length 1 specifying the string to append to
the end of the colnames in the return object.}

\item{fun}{function to use for aggregation. This function is expected to
return an atomic vector of length 1.}

\item{...}{additional named arguments to \code{fun}.}
}
\value{
data.frame of aggregated values. If \code{rep} is TRUE, then nrow =
  \code{nrow(data)}. If \code{rep} = FALSE, then nrow =
  \code{length(levels(interaction(data[grp.nm])))}. The names are specified
  by \code{paste0(vrb.nm, suffix)}. If \code{rtn.grp} = TRUE, then the group
  columns are appended to the begining of the data.frame.
}
\description{
\code{aggs} evaluates a function separately for each group and combines the
results back together into a data.frame that is returned. Depending on
\code{rep}, the results of \code{fun} are repeated for each element of
\code{data[vrb.nm]} in the group (TRUE) or only once for each group (FALSE).
Note, \code{aggs} evaluates \code{fun} separately for each variable
\code{vrb.nm} within \code{data}. If instead, you want to evaluate \code{fun}
for variables as a set \code{data[vrb.nm]}, then use \code{agg_dfm}.
}
\details{
If \code{rep} = TRUE, then \code{agg} calls \code{ave}; if \code{rep} =
FALSE, then \code{agg} calls \code{aggregate}.
}
\examples{
aggs(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month",
   fun = mean, na.rm = TRUE)
aggs(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month",
   rtn.grp = TRUE, fun = mean, na.rm = TRUE) # include the group columns
aggs(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month",
   rep = FALSE, fun = mean, na.rm = TRUE) # do NOT repeat aggregated values
aggs(data = mtcars, vrb.nm = c("mpg","cyl","disp"), grp.nm = c("vs","am"),
   rep = FALSE, fun = mean, na.rm = TRUE) # with multiple group columns
aggs(data = mtcars, vrb.nm = c("mpg","cyl","disp"), grp.nm = c("vs","am"),
   rep = FALSE, rtn.grp = FALSE, fun = mean, na.rm = TRUE) # without returning groups
}
\seealso{
\code{agg}
   \code{agg_dfm}
   \code{\link[stats]{ave}}
   \code{\link[stats]{aggregate}}
}
