% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_uniprot_data.R
\name{get_uniprot_data}
\alias{get_uniprot_data}
\title{Retrieve data from UniProt using UniProt's REST API}
\usage{
get_uniprot_data(
  query = NULL,
  base_url = "https://rest.uniprot.org/uniprotkb/",
  columns = c("accession", "id", "gene_names", "organism_id", "reviewed")
)
}
\arguments{
\item{query}{list of keys corresponding to UniProt's query fields.
For example :
list("gene_exact" = c("Pik3r1", "Pik3r2") ,
"organism" = c("10090", "9606"), "reviewed" = "yes").
See `query_fields` for available query fields.}

\item{base_url}{The base url for the UniProt REST API}

\item{columns}{names of UniProt data columns to retrieve.
Examples include "accession", "id", "gene_names", "keyword", "sequence".
See `return_fields` for available return fields.}
}
\value{
a list with the following items :
\describe{
  \item{url}{the query url}
  \item{status}{the http status code for the request}
  \item{messages}{messages returned by the REST API}
  \item{content}{a data.frame containing the query results}
}
}
\description{
Retrieve data from UniProt using UniProt's REST API
}
\examples{
#Getting gene names, keywords and protein sequences for a set of UniProt IDs.
ids <- c("P22682", "P47941")
cols <- c("accession", "id", "gene_names", "keyword", "sequence")
query = list("accession_id" = ids)
df <- get_uniprot_data(query = query, columns = cols)$content
df
}
